/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.block;

import java.util.Random;
import javax.annotation.Nonnull;
import knightminer.simplytea.block.TeaTrunkBlock;
import knightminer.simplytea.core.Registration;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SaplingBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class TeaSaplingBlock
extends SaplingBlock {
    public TeaSaplingBlock(Block.Properties props) {
        super(null, props);
    }

    public void func_225535_a_(@Nonnull ServerWorld world, @Nonnull Random rand, @Nonnull BlockPos pos, BlockState state) {
        if ((Integer)state.func_177229_b((IProperty)field_176479_b) == 0) {
            world.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)field_176479_b), 4);
        } else if (ForgeEventFactory.saplingGrowTree((IWorld)world, (Random)rand, (BlockPos)pos)) {
            TeaSaplingBlock.generateTree((IWorld)world, pos, rand);
        }
    }

    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean b) {
        for (int i = 1; i <= 3; ++i) {
            BlockState up = world.func_180495_p(pos.func_177981_b(i));
            if (up.isAir(world, pos) || up.func_185904_a().func_76222_j()) continue;
            return false;
        }
        return true;
    }

    public boolean func_180670_a(World world, Random random, BlockPos blockPos, BlockState blockState) {
        return (double)world.field_73012_v.nextFloat() < 0.45;
    }

    public static void generateTree(IWorld world, BlockPos pos, Random random) {
        BlockState trunk = (BlockState)Registration.tea_trunk.func_176223_P().func_206870_a((IProperty)TeaTrunkBlock.CLIPPED, (Comparable)Boolean.valueOf(false));
        world.func_180501_a(pos, (BlockState)trunk.func_206870_a(TeaTrunkBlock.TYPE, (Comparable)((Object)TeaTrunkBlock.TrunkType.STUMP)), 3);
        world.func_180501_a(pos.func_177984_a(), (BlockState)trunk.func_206870_a(TeaTrunkBlock.TYPE, (Comparable)((Object)TeaTrunkBlock.TrunkType.BOTTOM)), 3);
        int height = 3;
        if (world.func_175623_d(pos.func_177981_b(4))) {
            height += random.nextInt(world.func_175623_d(pos.func_177981_b(5)) ? 3 : 2);
        }
        for (int i = 2; i < height; ++i) {
            boolean north = random.nextBoolean();
            boolean south = random.nextBoolean();
            boolean west = random.nextBoolean();
            boolean east = random.nextBoolean();
            BlockPos branch = pos.func_177981_b(i);
            if (north) {
                TeaSaplingBlock.setBlockSafe(world, branch.func_177978_c(), (BlockState)trunk.func_206870_a(TeaTrunkBlock.TYPE, (Comparable)((Object)TeaTrunkBlock.TrunkType.SOUTH)));
            }
            if (east) {
                TeaSaplingBlock.setBlockSafe(world, branch.func_177974_f(), (BlockState)trunk.func_206870_a(TeaTrunkBlock.TYPE, (Comparable)((Object)TeaTrunkBlock.TrunkType.WEST)));
            }
            if (south) {
                TeaSaplingBlock.setBlockSafe(world, branch.func_177968_d(), (BlockState)trunk.func_206870_a(TeaTrunkBlock.TYPE, (Comparable)((Object)TeaTrunkBlock.TrunkType.NORTH)));
            }
            if (west) {
                TeaSaplingBlock.setBlockSafe(world, branch.func_177976_e(), (BlockState)trunk.func_206870_a(TeaTrunkBlock.TYPE, (Comparable)((Object)TeaTrunkBlock.TrunkType.EAST)));
            }
            world.func_180501_a(branch, (BlockState)trunk.func_206870_a(TeaTrunkBlock.TYPE, (Comparable)((Object)TeaTrunkBlock.TrunkType.MIDDLE)), 3);
        }
        world.func_180501_a(pos.func_177981_b(height), (BlockState)trunk.func_206870_a(TeaTrunkBlock.TYPE, (Comparable)((Object)TeaTrunkBlock.TrunkType.TOP)), 3);
    }

    private static void setBlockSafe(IWorld world, BlockPos pos, BlockState state) {
        BlockState old = world.func_180495_p(pos);
        if (old.isAir((IBlockReader)world, pos) || old.func_185904_a().func_76222_j() || old.func_177230_c().func_203417_a(BlockTags.field_206952_E)) {
            world.func_180501_a(pos, state, 3);
        }
    }
}

