/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.block;

import java.util.List;
import java.util.Locale;
import java.util.Random;
import knightminer.simplytea.core.Config;
import knightminer.simplytea.core.Registration;
import knightminer.simplytea.core.Util;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ServerWorld;
import net.minecraft.world.World;

public class TeaTrunkBlock
extends Block {
    public static final EnumProperty<TrunkType> TYPE = EnumProperty.func_177709_a((String)"type", TrunkType.class);
    public static final BooleanProperty CLIPPED = BooleanProperty.func_177716_a((String)"clipped");
    public static final ResourceLocation LEAVES_DROPS = new ResourceLocation("simplytea", "blocks/tea_leaves");
    public static final VoxelShape BOUNDS_STUMP = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape[] BOUNDS_UNCLIPPED = new VoxelShape[]{Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)12.0), Block.func_208617_a((double)4.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), Block.func_208617_a((double)2.0, (double)2.0, (double)4.0, (double)14.0, (double)14.0, (double)16.0), Block.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)12.0, (double)14.0, (double)14.0)};
    public static final VoxelShape[] BOUNDS_CLIPPED = new VoxelShape[]{Block.func_208617_a((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5), Block.func_208617_a((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5), Block.func_208617_a((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)8.0, (double)9.5), Block.func_208617_a((double)6.5, (double)6.5, (double)0.0, (double)9.5, (double)9.5, (double)8.0), Block.func_208617_a((double)8.0, (double)6.5, (double)6.5, (double)16.0, (double)9.5, (double)9.5), Block.func_208617_a((double)6.5, (double)6.5, (double)8.0, (double)9.5, (double)9.5, (double)16.0), Block.func_208617_a((double)0.0, (double)6.5, (double)6.5, (double)8.0, (double)9.5, (double)9.5)};

    public TeaTrunkBlock(Block.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(TYPE, (Comparable)((Object)TrunkType.STUMP))).func_206870_a((IProperty)CLIPPED, (Comparable)Boolean.valueOf(false)));
    }

    @Deprecated
    public void func_196267_b(BlockState state, World world, BlockPos pos, Random rand) {
        if (state.func_177230_c() == this && ((Boolean)state.func_177229_b((IProperty)CLIPPED)).booleanValue() && (double)rand.nextFloat() < Config.tree.leaf_growth_chance) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)CLIPPED, (Comparable)Boolean.valueOf(false)));
            world.func_184138_a(pos, state, (BlockState)state.func_206870_a((IProperty)CLIPPED, (Comparable)Boolean.valueOf(false)), 8);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)Registration.tea_sapling);
    }

    @Deprecated
    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult face) {
        if (state.func_177230_c() != this || ((Boolean)state.func_177229_b((IProperty)CLIPPED)).booleanValue() || state.func_177229_b(TYPE) == TrunkType.STUMP) {
            return false;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        Item item = heldItem.func_77973_b();
        if (item instanceof ShearsItem || item.getToolTypes(heldItem).contains("shears")) {
            ItemStack stack = heldItem.func_77946_l();
            stack.func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(hand));
            player.func_184611_a(hand, stack);
            if (world instanceof ServerWorld) {
                List<ItemStack> drops = Util.getBlockLoot(state, (ServerWorld)world, pos, player, heldItem, LEAVES_DROPS);
                for (ItemStack drop : drops) {
                    TeaTrunkBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
                }
            }
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)CLIPPED, (Comparable)Boolean.valueOf(true)), 8);
            world.func_184138_a(pos, state, (BlockState)state.func_206870_a((IProperty)CLIPPED, (Comparable)Boolean.valueOf(true)), 8);
            world.func_184133_a(player, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (state.func_177230_c() != this) {
            return BOUNDS_STUMP;
        }
        TrunkType type = (TrunkType)((Object)state.func_177229_b(TYPE));
        if (type == TrunkType.STUMP) {
            return BOUNDS_STUMP;
        }
        return ((Boolean)state.func_177229_b((IProperty)CLIPPED) != false ? BOUNDS_CLIPPED : BOUNDS_UNCLIPPED)[type.getIndex() - 1];
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{TYPE, CLIPPED});
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    public static enum TrunkType implements IStringSerializable
    {
        STUMP,
        BOTTOM,
        MIDDLE,
        TOP,
        NORTH,
        EAST,
        SOUTH,
        WEST;

        private int index = this.ordinal();

        public int getIndex() {
            return this.index;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }

        public static TrunkType fromIndex(int index) {
            if (index < 0 || index >= TrunkType.values().length) {
                index = 0;
            }
            return TrunkType.values()[index];
        }
    }
}

