/*
 * Decompiled with CFR 0.152.
 */
package elucent.simplytea.item;

import elucent.simplytea.SimplyTea;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TeapotFluidHandler
implements ICapabilityProvider,
IFluidHandlerItem {
    private ItemStack stack;

    public TeapotFluidHandler(ItemStack stack) {
        this.stack = stack;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.stack.func_77952_i() == 0 && capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.stack.func_77952_i() == 0 && capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)this);
        }
        return null;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(null, 1000)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.stack.func_77952_i() != 0 || resource == null || resource.amount < 1000) {
            return 0;
        }
        Fluid fluid = resource.getFluid();
        if (fluid != FluidRegistry.WATER && !fluid.getName().equals("milk")) {
            return 0;
        }
        if (doFill) {
            this.stack = new ItemStack(SimplyTea.teapot, 1, fluid == FluidRegistry.WATER ? 1 : 2);
        }
        return 1000;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    public ItemStack getContainer() {
        return this.stack;
    }
}

