/*
 * Decompiled with CFR 0.152.
 */
package elucent.simplytea.item;

import elucent.simplytea.core.Config;
import elucent.simplytea.item.ItemBase;
import elucent.simplytea.item.TeapotFluidHandler;
import java.util.List;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemTeapot
extends ItemBase {
    public ItemTeapot(String name, boolean addToTab) {
        super(name, addToTab);
        this.func_77625_d(1);
        this.field_77787_bX = true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        RayTraceResult raytraceresult;
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_77960_j() == 0 && (raytraceresult = this.func_77621_a(worldIn, playerIn, true)) != null && raytraceresult.field_72313_a != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState state = worldIn.func_180495_p(raytraceresult.func_178782_a());
            if (state.func_177230_c() == Blocks.field_150355_j) {
                stack.func_77964_b(1);
                playerIn.func_184611_a(handIn, stack);
                if (Config.teapot_consume_source) {
                    worldIn.func_175698_g(raytraceresult.func_178782_a());
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (state.func_177230_c() == Blocks.field_150383_bp && (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) == 3) {
                stack.func_77964_b(1);
                playerIn.func_184611_a(handIn, stack);
                Blocks.field_150383_bp.func_176590_a(worldIn, raytraceresult.func_178782_a(), state, 0);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (stack.func_77960_j() == 0 && target instanceof EntityCow && !player.field_71075_bZ.field_75098_d) {
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            stack.func_77964_b(2);
            return true;
        }
        return false;
    }

    @Override
    public void initModel() {
        String name = this.getRegistryName().func_110623_a();
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("simplytea", name + "_water"), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)2, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("simplytea", name + "_milk"), "inventory"));
    }

    public void func_77624_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        switch (stack.func_77960_j()) {
            case 0: {
                tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".tooltip.empty"), (Object[])new Object[0]));
                break;
            }
            case 1: {
                tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".tooltip.water"), (Object[])new Object[0]));
                break;
            }
            case 2: {
                tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".tooltip.milk"), (Object[])new Object[0]));
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(tab)) {
            stacks.add((Object)new ItemStack((Item)this, 1));
            stacks.add((Object)new ItemStack((Item)this, 1, 1));
            stacks.add((Object)new ItemStack((Item)this, 1, 2));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        if (stack.func_77952_i() == 0) {
            return new TeapotFluidHandler(stack);
        }
        return null;
    }
}

