/*
 * Decompiled with CFR 0.152.
 */
package elucent.simplytea;

import elucent.simplytea.block.BlockTeaSapling;
import elucent.simplytea.block.BlockTeaTrunk;
import elucent.simplytea.block.IItemBlock;
import elucent.simplytea.core.Config;
import elucent.simplytea.core.IMCHelper;
import elucent.simplytea.core.IModeledObject;
import elucent.simplytea.core.WorldGenTeaTrees;
import elucent.simplytea.item.ItemBase;
import elucent.simplytea.item.ItemCocoa;
import elucent.simplytea.item.ItemHotTeapot;
import elucent.simplytea.item.ItemTeaCup;
import elucent.simplytea.item.ItemTeaStick;
import elucent.simplytea.item.ItemTeapot;
import elucent.simplytea.potion.PotionCaffeinated;
import elucent.simplytea.potion.PotionRestful;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="simplytea", version="1.5", name="Simply Tea!", acceptedMinecraftVersions="[1.12]")
public class SimplyTea {
    public static final String MODID = "simplytea";
    public static final String NAME = "Simply Tea!";
    public static final String VERSION = "1.5";
    public static CreativeTabs tab = new CreativeTabs("simplytea"){

        public ItemStack func_78016_d() {
            return new ItemStack(leaf_tea);
        }
    };
    private static List<Item> items = new ArrayList<Item>();
    private static List<Block> blocks = new ArrayList<Block>();
    public static Block tea_sapling;
    public static Block tea_trunk;
    public static Item leaf_tea;
    public static Item black_tea;
    public static Item tea_stick;
    public static Item teabag;
    public static Item teabag_green;
    public static Item teabag_black;
    public static Item teabag_floral;
    public static Item teabag_chamomile;
    public static Item cup;
    public static Item cup_tea_black;
    public static Item cup_tea_green;
    public static Item cup_tea_floral;
    public static Item cup_tea_chai;
    public static Item cup_tea_chamomile;
    public static Item cup_cocoa;
    public static Item teapot;
    public static Item hot_teapot;
    public static Item frothed_teapot;
    public static Potion restful;
    public static Potion caffeinated;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        caffeinated = new PotionCaffeinated("caffeinated").setCustomIcon(1, 0);
        restful = new PotionRestful("restful").setCustomIcon(0, 0);
        leaf_tea = new ItemBase("leaf_tea", true);
        items.add(leaf_tea);
        black_tea = new ItemBase("black_tea", true);
        items.add(black_tea);
        tea_stick = new ItemTeaStick("tea_stick", true);
        items.add(tea_stick);
        teabag = new ItemBase("teabag", true);
        items.add(teabag);
        teabag_green = new ItemBase("teabag_green", true);
        items.add(teabag_green);
        teabag_black = new ItemBase("teabag_black", true);
        items.add(teabag_black);
        teabag_floral = new ItemBase("teabag_floral", true);
        items.add(teabag_floral);
        cup = new ItemBase("cup", true).func_77625_d(16);
        items.add(cup);
        cup_tea_black = new ItemTeaCup("cup_tea_black", Config.tea.black, 1, true);
        items.add(cup_tea_black);
        cup_tea_green = new ItemTeaCup("cup_tea_green", Config.tea.green, 1, true);
        items.add(cup_tea_green);
        cup_tea_floral = new ItemTeaCup("cup_tea_floral", Config.tea.floral, 20, true);
        items.add(cup_tea_floral);
        cup_tea_chai = new ItemTeaCup("cup_tea_chai", Config.tea.chai, 2, true);
        items.add(cup_tea_chai);
        cup_cocoa = new ItemCocoa("cup_cocoa", true);
        items.add(cup_cocoa);
        teapot = new ItemTeapot("teapot", true);
        items.add(teapot);
        hot_teapot = new ItemHotTeapot("hot_teapot", true);
        items.add(hot_teapot);
        frothed_teapot = new ItemHotTeapot("frothed_teapot", true);
        items.add(frothed_teapot);
        if (Loader.isModLoaded((String)"rustic")) {
            teabag_chamomile = new ItemBase("teabag_chamomile", true);
            items.add(teabag_chamomile);
            cup_tea_chamomile = new ItemTeaCup("cup_tea_chamomile", Config.tea.chamomile, 30, true);
            items.add(cup_tea_chamomile);
        }
        tea_sapling = new BlockTeaSapling("tea_sapling", true);
        blocks.add(tea_sapling);
        tea_trunk = new BlockTeaTrunk("tea_trunk", false);
        blocks.add(tea_trunk);
        if (Config.tree.enable_generation) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenTeaTrees(), (int)100);
        }
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block b : blocks) {
            event.getRegistry().register((IForgeRegistryEntry)b);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        for (Item i : items) {
            event.getRegistry().register((IForgeRegistryEntry)i);
        }
        for (Block b : blocks) {
            if (!(b instanceof IItemBlock)) continue;
            event.getRegistry().register((IForgeRegistryEntry)((IItemBlock)b).getItemBlock());
        }
    }

    @SubscribeEvent
    public void registerPotions(RegistryEvent.Register<Potion> event) {
        IForgeRegistry r = event.getRegistry();
        r.register((IForgeRegistryEntry)caffeinated);
        r.register((IForgeRegistryEntry)restful);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        GameRegistry.addSmelting((ItemStack)new ItemStack(teapot, 1, 1), (ItemStack)new ItemStack(hot_teapot, 1, 4), (float)0.1f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(teapot, 1, 2), (ItemStack)new ItemStack(frothed_teapot, 1, 4), (float)0.1f);
        GameRegistry.addSmelting((Item)leaf_tea, (ItemStack)new ItemStack(black_tea, 1), (float)0.1f);
        if (Loader.isModLoaded((String)"tconstruct")) {
            IMCHelper.addTinkersDrying(new ItemStack(leaf_tea), new ItemStack(black_tea), 300);
        }
        OreDictionary.registerOre((String)"treeSapling", (Block)tea_sapling);
        OreDictionary.registerOre((String)"stickWood", (Item)tea_stick);
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        for (Item i : items) {
            if (!(i instanceof IModeledObject)) continue;
            ((IModeledObject)i).initModel();
        }
        for (Block b : blocks) {
            if (!(b instanceof IModeledObject)) continue;
            ((IModeledObject)b).initModel();
        }
    }

    @SubscribeEvent
    public void playerWakeUp(PlayerWakeUpEvent event) {
        if (!event.shouldSetSpawn() || event.updateWorld()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_70644_a(caffeinated)) {
            player.func_184589_d(caffeinated);
            player.func_184589_d(restful);
            return;
        }
        PotionEffect effect = player.func_70660_b(restful);
        if (effect != null) {
            player.func_70691_i((float)((effect.func_76458_c() + 1) * 2));
            player.func_184589_d(restful);
        }
    }
}

