/*
 * Decompiled with CFR 0.152.
 */
package elucent.simplytea;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="simplytea", version="1.1", name="Simply Tea!", acceptedMinecraftVersions="[1.11.2]")
public class SimplyTea {
    public static final String MODID = "simplytea";
    public static final String NAME = "Simply Tea!";
    public static final String VERSION = "1.1";
    public static Random random = new Random();
    @SidedProxy(clientSide="elucent.simplytea.SimplyTea$ClientProxy", serverSide="elucent.simplytea.SimplyTea$CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs tab;
    private static List<Item> items;
    private static List<Block> blocks;
    public static Block tea_sapling;
    public static Block tea_trunk;
    public static Item leaf_tea;
    public static Item black_tea;
    public static Item cup;
    public static Item cup_tea_black;
    public static Item cup_tea_green;
    public static Item teabag;
    public static Item teapot;
    public static Item hot_teapot;
    public static Item teabag_green;
    public static Item teabag_black;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
    }

    public static void registerAll() {
        leaf_tea = new ItemBase("leaf_tea", true);
        items.add(leaf_tea);
        black_tea = new ItemBase("black_tea", true);
        items.add(black_tea);
        teabag = new ItemBase("teabag", true);
        items.add(teabag);
        teabag_green = new ItemBase("teabag_green", true);
        items.add(teabag_green);
        teabag_black = new ItemBase("teabag_black", true);
        items.add(teabag_black);
        cup = new ItemBase("cup", true).func_77625_d(1);
        items.add(cup);
        cup_tea_black = new ItemTeaCup("cup_tea_black", 4, 8.0f, true);
        items.add(cup_tea_black);
        cup_tea_green = new ItemTeaCup("cup_tea_green", 3, 5.0f, true);
        items.add(cup_tea_green);
        teapot = new ItemTeapot("teapot", true);
        items.add(teapot);
        hot_teapot = new ItemHotTeapot("hot_teapot", true);
        items.add(hot_teapot);
        tea_sapling = new BlockTeaSapling("tea_sapling", true);
        blocks.add(tea_sapling);
        tea_trunk = new BlockTeaTrunk("tea_trunk", true);
        blocks.add(tea_trunk);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenTeaTrees(), (int)100);
    }

    public static void registerRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(teabag, 4), new Object[]{true, new Object[]{"  S", "PP ", "PP ", Character.valueOf('S'), "string", Character.valueOf('P'), Items.field_151121_aF}}).setMirrored(true));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(teabag_green, 1), new Object[]{new ItemStack(teabag, 1), leaf_tea}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(teabag_black, 1), new Object[]{new ItemStack(teabag, 1), black_tea}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(cup, 1), new Object[]{true, new Object[]{"CBC", " C ", Character.valueOf('C'), Items.field_151119_aD, Character.valueOf('B'), new ItemStack(Items.field_151100_aR, 1, 15)}}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(teapot, 1), new Object[]{true, new Object[]{"CcC", "CC ", Character.valueOf('C'), Items.field_151119_aD, Character.valueOf('c'), new ItemStack(Items.field_151100_aR, 1, 6)}}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(cup_tea_green, 1), new Object[]{teabag_green, new ItemStack(hot_teapot, 1, 1), cup}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(cup_tea_black, 1), new Object[]{teabag_black, new ItemStack(hot_teapot, 1, 1), cup}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(cup_tea_green, 1), new Object[]{teabag_green, new ItemStack(hot_teapot, 1, 2), cup}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(cup_tea_black, 1), new Object[]{teabag_black, new ItemStack(hot_teapot, 1, 2), cup}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(cup_tea_green, 1), new Object[]{teabag_green, new ItemStack(hot_teapot, 1, 3), cup}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(cup_tea_black, 1), new Object[]{teabag_black, new ItemStack(hot_teapot, 1, 3), cup}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(cup_tea_green, 1), new Object[]{teabag_green, new ItemStack(hot_teapot, 1, 4), cup}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(cup_tea_black, 1), new Object[]{teabag_black, new ItemStack(hot_teapot, 1, 4), cup}));
        FurnaceRecipes.func_77602_a().func_151396_a(leaf_tea, new ItemStack(black_tea, 1), 0.1f);
        FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(teapot, 1, 1), new ItemStack(hot_teapot, 1, 4), 0.1f);
    }

    public static void registerModels() {
        for (Item i : items) {
            if (!(i instanceof IModeledObject)) continue;
            ((IModeledObject)i).initModel();
        }
        for (Block b : blocks) {
            if (!(b instanceof IModeledObject)) continue;
            ((IModeledObject)b).initModel();
        }
    }

    static {
        tab = new CreativeTabs(MODID){

            public ItemStack func_78016_d() {
                return new ItemStack(leaf_tea);
            }
        };
        items = new ArrayList<Item>();
        blocks = new ArrayList<Block>();
    }

    public static class WorldGenTeaTrees
    implements IWorldGenerator {
        public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
            if (random.nextInt(20) == 0) {
                int x = chunkX * 16 + 2 + random.nextInt(12);
                int z = chunkZ * 16 + 2 + random.nextInt(12);
                BlockPos p = new BlockPos(x, 0, z);
                Biome b = world.func_180494_b(p = world.func_175645_m(p));
                if ((BiomeDictionary.hasType((Biome)b, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || b == Biomes.field_76767_f || b == Biomes.field_76785_t) && world.func_180495_p(p.func_177977_b()).func_177230_c() instanceof BlockGrass && world.func_175623_d(p)) {
                    BlockTeaSapling.generateTree(world, p, Blocks.field_150350_a.func_176223_P(), random);
                }
            }
        }
    }

    public static class BlockTeaTrunk
    extends Block
    implements IModeledObject {
        public static final PropertyInteger TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)7);
        public static final PropertyBool CLIPPED = PropertyBool.func_177716_a((String)"clipped");
        public static final AxisAlignedBB AABB_BOTTOM = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
        public static final AxisAlignedBB AABB_BOTTOM_2 = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
        public static final AxisAlignedBB AABB_MID = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        public static final AxisAlignedBB AABB_TOP = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.75, 0.875);
        public static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.75);
        public static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.0, 0.125, 0.125, 0.75, 0.875, 0.875);
        public static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.125, 0.125, 0.25, 0.875, 0.875, 1.0);
        public static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.25, 0.125, 0.125, 1.0, 0.875, 0.875);
        public Item itemBlock = null;

        public BlockTeaTrunk(String name, boolean addToTab) {
            super(Material.field_151575_d);
            this.func_149672_a(SoundType.field_185848_a);
            this.setHarvestLevel("axe", -1);
            this.func_149711_c(1.8f);
            this.func_149663_c(name);
            this.setRegistryName("simplytea:" + name);
            if (addToTab) {
                this.func_149647_a(tab);
            }
            this.func_149675_a(true);
            GameRegistry.register((IForgeRegistryEntry)this);
            this.itemBlock = (Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
            GameRegistry.register((IForgeRegistryEntry)this.itemBlock);
        }

        public boolean func_149653_t() {
            return true;
        }

        public boolean func_149698_L() {
            return true;
        }

        public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random rand) {
            if (state.func_177230_c() == this && ((Boolean)state.func_177229_b((IProperty)CLIPPED)).booleanValue()) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)CLIPPED, (Comparable)Boolean.valueOf(false)));
                worldIn.func_184138_a(pos, state, state.func_177226_a((IProperty)CLIPPED, (Comparable)Boolean.valueOf(false)), 8);
            }
        }

        public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
            return new ItemStack(tea_sapling, 1);
        }

        public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (heldItem.func_77973_b() instanceof ItemShears && state.func_177230_c() == this && !((Boolean)state.func_177229_b((IProperty)CLIPPED)).booleanValue() && (Integer)state.func_177229_b((IProperty)TYPE) != 0) {
                ItemStack stack = heldItem.func_77946_l();
                ((ItemShears)heldItem.func_77973_b()).setDamage(stack, ((ItemShears)heldItem.func_77973_b()).getDamage(stack) + 1);
                if (((ItemShears)heldItem.func_77973_b()).getDamage(stack) > ((ItemShears)heldItem.func_77973_b()).func_77612_l()) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                } else {
                    player.func_184611_a(hand, stack);
                }
                this.func_176226_b(world, pos, state, 0);
                world.func_180501_a(pos, state.func_177226_a((IProperty)CLIPPED, (Comparable)Boolean.valueOf(true)), 8);
                world.func_184138_a(pos, state, state.func_177226_a((IProperty)CLIPPED, (Comparable)Boolean.valueOf(true)), 8);
                return true;
            }
            return false;
        }

        public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
            if (state.func_177230_c() == this) {
                if ((Integer)state.func_177229_b((IProperty)TYPE) == 0) {
                    return AABB_BOTTOM;
                }
                if ((Integer)state.func_177229_b((IProperty)TYPE) == 1) {
                    return AABB_BOTTOM_2;
                }
                if ((Integer)state.func_177229_b((IProperty)TYPE) == 2) {
                    return AABB_MID;
                }
                if ((Integer)state.func_177229_b((IProperty)TYPE) == 3) {
                    return AABB_TOP;
                }
                if ((Integer)state.func_177229_b((IProperty)TYPE) == 4) {
                    return AABB_NORTH;
                }
                if ((Integer)state.func_177229_b((IProperty)TYPE) == 5) {
                    return AABB_EAST;
                }
                if ((Integer)state.func_177229_b((IProperty)TYPE) == 6) {
                    return AABB_SOUTH;
                }
                if ((Integer)state.func_177229_b((IProperty)TYPE) == 7) {
                    return AABB_WEST;
                }
            }
            return AABB_MID;
        }

        public BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{TYPE, CLIPPED});
        }

        public int func_176201_c(IBlockState state) {
            return (Integer)state.func_177229_b((IProperty)TYPE) + ((Boolean)state.func_177229_b((IProperty)CLIPPED) != false ? 8 : 0);
        }

        public IBlockState func_176203_a(int meta) {
            return this.func_176223_P().func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(meta % 8)).func_177226_a((IProperty)CLIPPED, (Comparable)Boolean.valueOf(meta >= 8));
        }

        public boolean func_149662_c(IBlockState state) {
            return false;
        }

        public boolean func_149686_d(IBlockState state) {
            return false;
        }

        public boolean func_149730_j(IBlockState state) {
            return false;
        }

        public BlockRenderLayer func_180664_k() {
            return BlockRenderLayer.CUTOUT_MIPPED;
        }

        public void func_149666_a(Item i, CreativeTabs tab, NonNullList list) {
        }

        public NonNullList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
            NonNullList drops = NonNullList.func_191196_a();
            if (state.func_177230_c() == this) {
                if ((Integer)state.func_177229_b((IProperty)TYPE) > 0 && !((Boolean)state.func_177229_b((IProperty)CLIPPED)).booleanValue()) {
                    drops.add((Object)new ItemStack(leaf_tea, random.nextInt(3) + 1));
                    if (random.nextInt(10) == 0) {
                        drops.add((Object)new ItemStack(tea_sapling, 1));
                    }
                }
                drops.add((Object)new ItemStack(Items.field_151055_y, random.nextInt(3) + 1));
            }
            return drops;
        }

        @Override
        public void initModel() {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString(), "inventory"));
        }
    }

    public static class BlockTeaSapling
    extends BlockBush
    implements IGrowable,
    IModeledObject {
        public Item itemBlock = null;
        public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);

        public BlockTeaSapling(String name, boolean addToTab) {
            this.func_149672_a(SoundType.field_185850_c);
            this.func_149663_c(name);
            this.setRegistryName("simplytea:" + name);
            if (addToTab) {
                this.func_149647_a(tab);
            }
            this.func_149675_a(true);
            GameRegistry.register((IForgeRegistryEntry)this);
            this.itemBlock = (Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
            GameRegistry.register((IForgeRegistryEntry)this.itemBlock);
        }

        public BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
        }

        public int func_176201_c(IBlockState state) {
            return (Integer)state.func_177229_b((IProperty)STAGE);
        }

        public IBlockState func_176203_a(int meta) {
            return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta));
        }

        public boolean func_149698_L() {
            return true;
        }

        public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random rand) {
            if (!worldIn.field_72995_K) {
                super.func_180650_b(worldIn, pos, state, rand);
                if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                    this.grow(worldIn, pos, state, rand);
                }
            }
        }

        public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
            if (!worldIn.field_72995_K) {
                super.func_180650_b(worldIn, pos, state, rand);
                if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                    this.grow(worldIn, pos, state, rand);
                }
            }
        }

        public void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
            if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
                worldIn.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
            } else {
                BlockTeaSapling.generateTree(worldIn, pos, state, rand);
            }
        }

        public boolean func_149662_c(IBlockState state) {
            return false;
        }

        public boolean func_149686_d(IBlockState state) {
            return false;
        }

        public boolean func_149730_j(IBlockState state) {
            return false;
        }

        public static void generateTree(World world, BlockPos pos, IBlockState state, Random random) {
            int height = random.nextInt(3) + 4;
            world.func_175656_a(pos, tea_trunk.func_176223_P().func_177226_a((IProperty)BlockTeaTrunk.TYPE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)BlockTeaTrunk.CLIPPED, (Comparable)Boolean.valueOf(false)));
            for (int i = 1; i < height; ++i) {
                if (i == 1) {
                    world.func_175656_a(pos.func_177981_b(i), tea_trunk.func_176223_P().func_177226_a((IProperty)BlockTeaTrunk.TYPE, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)BlockTeaTrunk.CLIPPED, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                if (i < height - 1) {
                    boolean north = random.nextBoolean();
                    boolean south = random.nextBoolean();
                    boolean west = random.nextBoolean();
                    boolean east = random.nextBoolean();
                    if (north) {
                        world.func_175656_a(pos.func_177981_b(i).func_177978_c(), tea_trunk.func_176223_P().func_177226_a((IProperty)BlockTeaTrunk.TYPE, (Comparable)Integer.valueOf(6)).func_177226_a((IProperty)BlockTeaTrunk.CLIPPED, (Comparable)Boolean.valueOf(false)));
                    }
                    if (east) {
                        world.func_175656_a(pos.func_177981_b(i).func_177974_f(), tea_trunk.func_176223_P().func_177226_a((IProperty)BlockTeaTrunk.TYPE, (Comparable)Integer.valueOf(7)).func_177226_a((IProperty)BlockTeaTrunk.CLIPPED, (Comparable)Boolean.valueOf(false)));
                    }
                    if (south) {
                        world.func_175656_a(pos.func_177981_b(i).func_177968_d(), tea_trunk.func_176223_P().func_177226_a((IProperty)BlockTeaTrunk.TYPE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)BlockTeaTrunk.CLIPPED, (Comparable)Boolean.valueOf(false)));
                    }
                    if (west) {
                        world.func_175656_a(pos.func_177981_b(i).func_177976_e(), tea_trunk.func_176223_P().func_177226_a((IProperty)BlockTeaTrunk.TYPE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)BlockTeaTrunk.CLIPPED, (Comparable)Boolean.valueOf(false)));
                    }
                    world.func_175656_a(pos.func_177981_b(i), tea_trunk.func_176223_P().func_177226_a((IProperty)BlockTeaTrunk.TYPE, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)BlockTeaTrunk.CLIPPED, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                world.func_175656_a(pos.func_177981_b(i), tea_trunk.func_176223_P().func_177226_a((IProperty)BlockTeaTrunk.TYPE, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)BlockTeaTrunk.CLIPPED, (Comparable)Boolean.valueOf(false)));
            }
        }

        @Override
        public void initModel() {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString(), "inventory"));
        }

        public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
            return world.func_175623_d(pos.func_177981_b(1)) && world.func_175623_d(pos.func_177981_b(2)) && world.func_175623_d(pos.func_177981_b(3)) && world.func_175623_d(pos.func_177981_b(4)) && world.func_175623_d(pos.func_177981_b(5)) && world.func_175623_d(pos.func_177981_b(6));
        }

        public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
            this.grow(worldIn, pos, state, rand);
        }

        public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
            return true;
        }
    }

    public static class ItemTeaCup
    extends ItemFood
    implements IModeledObject {
        public ItemTeaCup(String name, int food, float sat, boolean addToTab) {
            super(food, sat, false);
            this.func_77625_d(1);
            this.setRegistryName("simplytea:" + name);
            this.func_77655_b(name);
            if (addToTab) {
                this.func_77637_a(tab);
            }
            GameRegistry.register((IForgeRegistryEntry)this);
        }

        public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
            ItemStack stack = playerIn.func_184586_b(handIn);
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }

        public EnumAction func_77661_b(ItemStack stack) {
            return EnumAction.DRINK;
        }

        public int func_77626_a(ItemStack stack) {
            return 20;
        }

        @Override
        public void initModel() {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }

        public boolean showDurabilityBar(ItemStack stack) {
            return stack.func_77952_i() > 0;
        }

        public double getDurabilityForDisplay(ItemStack stack) {
            if (stack.func_77952_i() > 0) {
                return (double)stack.func_77952_i() / 2.0;
            }
            return 0.0;
        }

        public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase base) {
            ItemStack s = stack.func_77946_l();
            super.func_77654_b(stack, world, base);
            s.func_77964_b(stack.func_77952_i() + 1);
            if (s.func_77952_i() >= 2) {
                return new ItemStack(cup, 1);
            }
            return s;
        }
    }

    public static class ItemTeapot
    extends ItemBase {
        public ItemTeapot(String name, boolean addToTab) {
            super(name, addToTab);
            this.func_77625_d(1);
        }

        public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
            IBlockState state;
            RayTraceResult raytraceresult;
            ItemStack stack = playerIn.func_184586_b(handIn);
            if (stack.func_77960_j() == 0 && (raytraceresult = this.func_77621_a(worldIn, playerIn, true)) != null && raytraceresult.field_72313_a != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK && (state = worldIn.func_180495_p(raytraceresult.func_178782_a())).func_177230_c() == Blocks.field_150355_j) {
                stack.func_77964_b(1);
                playerIn.func_184611_a(handIn, stack);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }

        @Override
        public void initModel() {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }

        public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
            if (stack.func_77960_j() == 0) {
                tooltip.add(I18n.func_135052_a((String)"simplytea.tooltip.empty", (Object[])new Object[0]));
            }
            if (stack.func_77960_j() == 1) {
                tooltip.add(I18n.func_135052_a((String)"simplytea.tooltip.water", (Object[])new Object[0]));
            }
        }

        public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> stacks) {
            if (item == this) {
                stacks.add((Object)new ItemStack((Item)this, 1));
                stacks.add((Object)new ItemStack((Item)this, 1, 1));
            }
        }
    }

    public static class ItemHotTeapot
    extends ItemBase {
        public ItemHotTeapot(String name, boolean addToTab) {
            super(name, addToTab);
            this.func_77642_a(this);
            this.func_77625_d(1);
        }

        public boolean hasContainerItem(ItemStack stack) {
            return true;
        }

        public ItemStack getContainerItem(ItemStack stack) {
            ItemStack c = stack.func_77946_l();
            c.func_77964_b(Math.max(0, stack.func_77952_i() - 1));
            if (c.func_77952_i() == 0) {
                return new ItemStack(teapot, 1);
            }
            return c;
        }

        public boolean showDurabilityBar(ItemStack stack) {
            return stack.func_77960_j() < 4;
        }

        public double getDurabilityForDisplay(ItemStack stack) {
            return 1.0 - (double)stack.func_77960_j() / 4.0;
        }

        @Override
        public void initModel() {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)2, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)3, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)4, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }

        public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
            tooltip.add(I18n.func_135052_a((String)"simplytea.tooltip.boiling", (Object[])new Object[0]));
        }

        public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> stacks) {
            if (item == this) {
                stacks.add((Object)new ItemStack((Item)this, 1, 4));
            }
        }
    }

    public static class ItemBase
    extends Item
    implements IModeledObject {
        public ItemBase(String name, boolean addToTab) {
            this.setRegistryName("simplytea:" + name);
            this.func_77655_b(name);
            if (addToTab) {
                this.func_77637_a(tab);
            }
            GameRegistry.register((IForgeRegistryEntry)this);
        }

        @Override
        public void initModel() {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }
    }

    public static interface IModeledObject {
        @SideOnly(value=Side.CLIENT)
        public void initModel();
    }

    public static class ClientProxy
    extends CommonProxy {
        @Override
        public void preInit(FMLPreInitializationEvent event) {
            super.preInit(event);
            SimplyTea.registerModels();
        }
    }

    public static class CommonProxy {
        public void preInit(FMLPreInitializationEvent event) {
            SimplyTea.registerAll();
            SimplyTea.registerRecipes();
        }
    }
}

