/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootModifierManager;

public class AddEntryLootModifier
extends LootModifier {
    private static final Codec<LootPoolEntryContainer> LOOT_POOL_ENTRY_CODEC = Codec.PASSTHROUGH.flatXmap(d -> {
        try {
            LootPoolEntryContainer entry = (LootPoolEntryContainer)LootModifierManager.GSON_INSTANCE.fromJson(AddEntryLootModifier.getJson(d), LootPoolEntryContainer.class);
            return DataResult.success((Object)entry);
        }
        catch (JsonSyntaxException e) {
            LootModifierManager.LOGGER.warn("Unable to decode entry", (Throwable)e);
            return DataResult.error(() -> e.getMessage());
        }
    }, entry -> {
        try {
            JsonElement element = LootModifierManager.GSON_INSTANCE.toJsonTree(entry);
            return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)element));
        }
        catch (JsonSyntaxException e) {
            LootModifierManager.LOGGER.warn("Unable to encode entry", (Throwable)e);
            return DataResult.error(() -> e.getMessage());
        }
    });
    private static final Codec<LootItemFunction> LOOT_ITEM_FUNCTION_CODEC = Codec.PASSTHROUGH.flatXmap(d -> {
        try {
            LootItemFunction entry = (LootItemFunction)LootModifierManager.GSON_INSTANCE.fromJson(AddEntryLootModifier.getJson(d), LootItemFunction.class);
            return DataResult.success((Object)entry);
        }
        catch (JsonSyntaxException e) {
            LootModifierManager.LOGGER.warn("Unable to decode function", (Throwable)e);
            return DataResult.error(() -> e.getMessage());
        }
    }, function -> {
        try {
            JsonElement element = LootModifierManager.GSON_INSTANCE.toJsonTree(function);
            return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)element));
        }
        catch (JsonSyntaxException e) {
            LootModifierManager.LOGGER.warn("Unable to encode function", (Throwable)e);
            return DataResult.error(() -> e.getMessage());
        }
    });
    public static final Codec<AddEntryLootModifier> CODEC = RecordCodecBuilder.create(inst -> AddEntryLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)LOOT_POOL_ENTRY_CODEC.fieldOf("entry").forGetter(m -> m.entry), (App)LOOT_ITEM_FUNCTION_CODEC.listOf().optionalFieldOf("functions", Collections.emptyList()).forGetter(m -> m.functions), (App)Codec.BOOL.fieldOf("require_empty").orElse((Object)false).forGetter(m -> m.requireEmpty))).apply((Applicative)inst, AddEntryLootModifier::new));
    private final LootPoolEntryContainer entry;
    private final List<LootItemFunction> functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> combinedFunctions;
    private final boolean requireEmpty;

    protected AddEntryLootModifier(LootItemCondition[] conditionsIn, LootPoolEntryContainer entry, List<LootItemFunction> functions, boolean requireEmpty) {
        super(conditionsIn);
        this.entry = entry;
        this.functions = functions;
        this.combinedFunctions = LootItemFunctions.m_80770_((BiFunction[])((BiFunction[])functions.toArray(LootItemFunction[]::new)));
        this.requireEmpty = requireEmpty;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        block3: {
            block2: {
                if (!this.requireEmpty) break block2;
                if (!generatedLoot.isEmpty()) break block3;
            }
            Consumer consumer = LootItemFunction.m_80724_(this.combinedFunctions, arg_0 -> generatedLoot.add(arg_0), (LootContext)context);
            this.entry.m_6562_(context, generator -> generator.m_6941_(consumer, context));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    private static <U> JsonElement getJson(Dynamic<?> dynamic) {
        Dynamic<?> typed = dynamic;
        return typed.getValue() instanceof JsonElement ? (JsonElement)typed.getValue() : (JsonElement)typed.getOps().convertTo((DynamicOps)JsonOps.INSTANCE, typed.getValue());
    }
}

