/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.core;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import knightminer.simplytea.block.TeaTrunkBlock;
import knightminer.simplytea.core.Config;
import knightminer.simplytea.data.AddEntryLootModifier;
import knightminer.simplytea.data.gen.BlockTagGenerator;
import knightminer.simplytea.data.gen.ItemTagGenerator;
import knightminer.simplytea.data.gen.LootTableGenerator;
import knightminer.simplytea.data.gen.RecipeGenerator;
import knightminer.simplytea.data.gen.ShapelessHoneyRecipe;
import knightminer.simplytea.data.gen.WorldgenGenerator;
import knightminer.simplytea.item.CocoaItem;
import knightminer.simplytea.item.HotTeapotItem;
import knightminer.simplytea.item.TeaCupItem;
import knightminer.simplytea.item.TeaStickItem;
import knightminer.simplytea.item.TeapotItem;
import knightminer.simplytea.item.TooltipItem;
import knightminer.simplytea.item.WoodBlockItem;
import knightminer.simplytea.potion.CaffeinatedEffect;
import knightminer.simplytea.potion.EnderfallingEffect;
import knightminer.simplytea.potion.InvigoratedEffect;
import knightminer.simplytea.potion.RelaxedEffect;
import knightminer.simplytea.potion.RestfulEffect;
import knightminer.simplytea.worldgen.TeaTreeFeature;
import knightminer.simplytea.worldgen.TeaTreeGrower;
import knightminer.simplytea.worldgen.TreeGenEnabledPlacement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(modid="simplytea", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Registration {
    public static CreativeModeTab group;
    public static MobEffect restful;
    public static MobEffect relaxed;
    public static MobEffect caffeinated;
    public static MobEffect invigorated;
    public static MobEffect enderfalling;
    public static SaplingBlock tea_sapling;
    public static Block tea_trunk;
    public static Block tea_fence;
    public static Block tea_fence_gate;
    public static Block potted_tea_sapling;
    public static Item tea_leaf;
    public static Item black_tea;
    public static Item tea_stick;
    public static Item ice_cube;
    public static Item chorus_petal;
    public static Item teabag;
    public static Item teabag_black;
    public static Item teabag_floral;
    public static Item teabag_chorus;
    public static Item teabag_green;
    public static Item unfired_teapot;
    public static Item teapot;
    public static Item teapot_water;
    public static Item teapot_milk;
    public static Item teapot_hot;
    public static Item teapot_frothed;
    public static Item unfired_cup;
    public static Item cup;
    public static Item cup_tea_black;
    public static Item cup_tea_green;
    public static Item cup_tea_floral;
    public static Item cup_tea_chai;
    public static Item cup_tea_iced;
    public static Item cup_tea_chorus;
    public static Item cup_cocoa;
    public static PlacementModifierType<TreeGenEnabledPlacement> tree_gen_enabled;
    public static Feature<NoneFeatureConfiguration> tea_tree;
    public static RecipeSerializer<?> shapeless_honey;
    public static ResourceKey<ConfiguredFeature<?, ?>> configured_tea_tree;
    public static ResourceKey<PlacedFeature> placed_tea_tree;
    public static ResourceKey<BiomeModifier> tea_tree_biome_modifier;

    @SubscribeEvent
    static void registerObjects(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.MOB_EFFECTS, r -> {
            restful = Registration.register(r, new RestfulEffect(), "restful");
            relaxed = Registration.register(r, new RelaxedEffect(), "relaxed");
            caffeinated = Registration.register(r, new CaffeinatedEffect(), "caffeinated");
            invigorated = Registration.register(r, new InvigoratedEffect(), "invigorated");
            enderfalling = Registration.register(r, new EnderfallingEffect(), "enderfalling");
        });
        event.register(ForgeRegistries.Keys.BLOCKS, r -> {
            BlockBehaviour.Properties props = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_278183_().m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_);
            tea_fence = (Block)Registration.register(r, new FenceBlock(props), "tea_fence");
            tea_fence_gate = (Block)Registration.register(r, new FenceGateBlock(props, WoodType.f_61830_), "tea_fence_gate");
            props = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_278166_(PushReaction.DESTROY).m_60910_().m_60977_().m_60978_(0.0f).m_60918_(SoundType.f_56740_);
            tea_sapling = Registration.register(r, new SaplingBlock((AbstractTreeGrower)new TeaTreeGrower(), props), "tea_sapling");
            props = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_278183_().m_280658_(NoteBlockInstrument.BASS).m_284180_(MapColor.f_283748_).m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60977_();
            tea_trunk = Registration.register(r, new TeaTrunkBlock(props), "tea_trunk");
            props = BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.DESTROY).m_60978_(0.0f).m_60955_();
            potted_tea_sapling = (Block)Registration.register(r, new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, () -> tea_sapling, props), "potted_tea_sapling");
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(new ResourceLocation("simplytea", "tea_sapling"), () -> potted_tea_sapling);
        });
        event.register(ForgeRegistries.Keys.ITEMS, r -> {
            Item.Properties props = new Item.Properties();
            tea_leaf = Registration.register(r, new TooltipItem(props), "tea_leaf");
            black_tea = Registration.register(r, new TooltipItem(props), "black_tea");
            tea_stick = Registration.register(r, new TeaStickItem(props), "tea_stick");
            ice_cube = Registration.register(r, new TooltipItem(props), "ice_cube");
            chorus_petal = Registration.register(r, new TooltipItem(props), "chorus_petal");
            teabag = Registration.register(r, new Item(props), "teabag");
            teabag_black = Registration.register(r, new Item(props), "teabag_black");
            teabag_floral = Registration.register(r, new Item(props), "teabag_floral");
            teabag_chorus = Registration.register(r, new Item(props), "teabag_chorus");
            teabag_green = Registration.register(r, new Item(props), "teabag_green");
            Registration.registerBlockItem((RegisterEvent.RegisterHelper<Item>)r, new WoodBlockItem(tea_fence, props));
            Registration.registerBlockItem((RegisterEvent.RegisterHelper<Item>)r, new WoodBlockItem(tea_fence_gate, props));
            Registration.registerBlockItem((RegisterEvent.RegisterHelper<Item>)r, new BlockItem((Block)tea_sapling, props));
            props = new Item.Properties().m_41487_(16);
            unfired_teapot = Registration.register(r, new Item(props), "unfired_teapot");
            teapot = Registration.register(r, new TeapotItem(props), "teapot");
            unfired_cup = Registration.register(r, new Item(props), "unfired_cup");
            cup = Registration.register(r, new Item(props), "cup");
            props.m_41495_(teapot).m_41487_(1);
            teapot_water = Registration.register(r, new TooltipItem(props), "teapot_water");
            teapot_milk = Registration.register(r, new TooltipItem(props), "teapot_milk");
            props.setNoRepair().m_41503_(4);
            teapot_hot = Registration.register(r, new HotTeapotItem(props), "teapot_hot");
            teapot_frothed = Registration.register(r, new HotTeapotItem(props), "teapot_frothed");
            props = new Item.Properties().m_41487_(1).m_41503_(2).setNoRepair().m_41495_(cup);
            cup_tea_black = Registration.register(r, new TeaCupItem(props.m_41489_((FoodProperties)Config.SERVER.black_tea)), "cup_tea_black");
            cup_tea_green = Registration.register(r, new TeaCupItem(props.m_41489_((FoodProperties)Config.SERVER.green_tea)), "cup_tea_green");
            cup_tea_floral = Registration.register(r, new TeaCupItem(props.m_41489_((FoodProperties)Config.SERVER.floral_tea)), "cup_tea_floral");
            cup_tea_chai = Registration.register(r, new TeaCupItem(props.m_41489_((FoodProperties)Config.SERVER.chai_tea)), "cup_tea_chai");
            cup_tea_iced = Registration.register(r, new TeaCupItem(props.m_41489_((FoodProperties)Config.SERVER.iced_tea)), "cup_tea_iced");
            cup_tea_chorus = Registration.register(r, new TeaCupItem(props.m_41489_((FoodProperties)Config.SERVER.chorus_tea)), "cup_tea_chorus");
            cup_cocoa = Registration.register(r, new CocoaItem(props.m_41489_((FoodProperties)Config.SERVER.cocoa)), "cup_cocoa");
        });
        event.register(Registries.f_279569_, r -> {
            group = Registration.register(r, CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)tea_leaf)).withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256731_}).m_257941_((Component)Component.m_237115_((String)"itemGroup.simplytea")).m_257501_((displayParameters, output) -> ForgeRegistries.ITEMS.getValues().stream().filter(item -> ForgeRegistries.ITEMS.getKey(item).m_135827_().equals("simplytea")).forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246326_(arg_0))).m_257652_(), "simplytea");
        });
        event.register(ForgeRegistries.Keys.FEATURES, r -> {
            tea_tree = Registration.register(r, new TeaTreeFeature(), "tea_tree");
        });
        event.register(ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, r -> Registration.register(r, AddEntryLootModifier.CODEC, "add_loot_entry"));
        event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, r -> {
            shapeless_honey = Registration.register(r, new ShapelessHoneyRecipe.Serializer(), "shapeless_honey");
        });
        event.register(Registries.f_256843_, r -> {
            tree_gen_enabled = Registration.register(r, () -> TreeGenEnabledPlacement.CODEC, "tree_gen_enabled");
        });
    }

    @SubscribeEvent
    static void registerMisc(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            if (Blocks.f_50083_ instanceof FireBlock) {
                FireBlock fire = (FireBlock)Blocks.f_50083_;
                fire.m_53444_(tea_fence, 5, 20);
                fire.m_53444_(tea_fence_gate, 5, 20);
                fire.m_53444_(tea_trunk, 15, 30);
            }
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)tea_leaf);
            ComposterBlock.m_51920_((float)0.4f, (ItemLike)black_tea);
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)chorus_petal);
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)tea_sapling);
            RestfulEffect.addConflict(caffeinated);
            RestfulEffect.addConflict(invigorated);
            CauldronInteraction.f_175607_.put(teapot, (state, level, pos, player, hand, stack) -> {
                if (Config.SERVER.teapot.fillFromCauldron()) {
                    return CauldronInteraction.m_175635_((BlockState)state, (Level)level, (BlockPos)pos, (Player)player, (InteractionHand)hand, (ItemStack)stack, (ItemStack)new ItemStack((ItemLike)teapot_water), s -> (Integer)s.m_61143_((Property)LayeredCauldronBlock.f_153514_) == 3, (SoundEvent)SoundEvents.f_11781_);
                }
                return InteractionResult.PASS;
            });
        });
    }

    @SubscribeEvent
    static void gatherData(GatherDataEvent event) {
        if (event.includeServer()) {
            ExistingFileHelper existing = event.getExistingFileHelper();
            DataGenerator generator = event.getGenerator();
            PackOutput output = generator.getPackOutput();
            CompletableFuture lookupProvider = event.getLookupProvider();
            BlockTagGenerator blockTags = new BlockTagGenerator(output, lookupProvider, existing);
            generator.addProvider(event.includeServer(), (DataProvider)blockTags);
            generator.addProvider(event.includeServer(), (DataProvider)new ItemTagGenerator(output, blockTags, lookupProvider, existing));
            generator.addProvider(event.includeServer(), (DataProvider)new RecipeGenerator(output));
            generator.addProvider(event.includeServer(), (DataProvider)new LootTableGenerator(output));
            generator.addProvider(event.includeServer(), (DataProvider)new WorldgenGenerator(output, lookupProvider, Set.of("simplytea")));
        }
    }

    private static <V extends R, R> void register(RegisterEvent.RegisterHelper<R> helper, V value, ResourceLocation location) {
        helper.register(location, value);
    }

    private static <V extends R, R> V register(RegisterEvent.RegisterHelper<R> helper, V value, String name) {
        helper.register(name, value);
        return value;
    }

    private static void registerBlockItem(RegisterEvent.RegisterHelper<Item> helper, BlockItem item) {
        ResourceLocation rl = ForgeRegistries.BLOCKS.getKey((Object)item.m_40614_());
        Registration.register(helper, item, Objects.requireNonNull(rl));
    }

    static {
        configured_tea_tree = FeatureUtils.m_255087_((String)"simplytea:tea_tree");
        placed_tea_tree = PlacementUtils.m_255070_((String)"simplytea:tea_tree");
        tea_tree_biome_modifier = ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("simplytea", "tea_tree"));
    }
}

