/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.data.gen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import javax.annotation.Nullable;
import knightminer.simplytea.core.Registration;
import knightminer.simplytea.item.TeaCupItem;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ShapelessHoneyRecipe
extends ShapelessRecipe {
    private final Item tea;
    private final Ingredient honey;
    private final String tag;

    public ShapelessHoneyRecipe(ResourceLocation id, String group, ItemLike tea, Ingredient honey, String tag) {
        super(id, group, TeaCupItem.withHoney(new ItemStack(tea), tag), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{tea}), honey}));
        this.tea = tea.m_5456_();
        this.honey = honey;
        this.tag = tag;
    }

    public RecipeSerializer<?> m_7707_() {
        return Registration.shapeless_honey;
    }

    public boolean m_5818_(CraftingContainer inv, Level worldIn) {
        if (!super.m_5818_(inv, worldIn)) {
            return false;
        }
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() != this.tea) continue;
            return !TeaCupItem.hasHoney(stack, this.tag);
        }
        return false;
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() != this.tea) continue;
            return TeaCupItem.withHoney(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1), this.tag);
        }
        return this.m_8043_().m_41777_();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList list = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = inv.m_8020_(i);
            if (!item.hasContainerItem() || item.m_41720_() == this.tea) continue;
            list.set(i, (Object)item.getContainerItem());
        }
        return list;
    }

    public static class Finished
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Item tea;
        private final Ingredient honey;
        private final String tag;
        private final ResourceLocation advancementId;
        private final Advancement.Builder advancementBuilder;

        public Finished(ResourceLocation id, String group, ItemLike tea, Ingredient honey, String tag, @Nullable ResourceLocation advancementId, @Nullable Advancement.Builder advancementBuilder) {
            this.id = id;
            this.group = group;
            this.tea = tea.m_5456_();
            this.honey = honey;
            this.tag = tag;
            this.advancementId = advancementId;
            this.advancementBuilder = advancementBuilder;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return Registration.shapeless_honey;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.addProperty("tea", Objects.requireNonNull(this.tea.getRegistryName()).toString());
            json.add("honey", this.honey.m_43942_());
            json.addProperty("tag", this.tag);
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }

        @Nullable
        public JsonObject m_5860_() {
            if (this.advancementBuilder == null) {
                return null;
            }
            return this.advancementBuilder.m_138400_();
        }
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ShapelessHoneyRecipe> {
        public ShapelessHoneyRecipe fromJson(ResourceLocation id, JsonObject json) {
            String group = GsonHelper.m_13906_((JsonObject)json, (String)"group");
            String name = GsonHelper.m_13906_((JsonObject)json, (String)"tea");
            ResourceLocation location = ResourceLocation.m_135820_((String)name);
            if (location == null) {
                throw new JsonSyntaxException("Invalid tea_cup location '" + name + "'");
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(location);
            if (item == null || item == Items.f_41852_) {
                throw new JsonSyntaxException("Missing tea_cup item '" + name + "'");
            }
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("honey"));
            String tag = GsonHelper.m_13851_((JsonObject)json, (String)"tag", (String)"with_honey");
            return new ShapelessHoneyRecipe(id, group, (ItemLike)item, ingredient, tag);
        }

        @Nullable
        public ShapelessHoneyRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            Item item = (Item)buffer.readRegistryIdUnsafe(ForgeRegistries.ITEMS);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            String tag = buffer.m_130136_(Short.MAX_VALUE);
            return new ShapelessHoneyRecipe(id, group, (ItemLike)item, ingredient, tag);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapelessHoneyRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (IForgeRegistryEntry)recipe.tea);
            recipe.honey.m_43923_(buffer);
            buffer.m_130070_(recipe.tag);
        }
    }
}

