/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootFunctionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class AddEntryLootModifier
extends LootModifier {
    private static final Gson GSON = LootSerializers.func_237387_b_().create();
    private final LootEntry entry;
    private final ILootFunction[] functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> combinedFunctions;
    private final boolean requireEmpty;

    protected AddEntryLootModifier(ILootCondition[] conditionsIn, LootEntry entry, ILootFunction[] functions, boolean requireEmpty) {
        super(conditionsIn);
        this.entry = entry;
        this.functions = functions;
        this.combinedFunctions = LootFunctionManager.func_216241_a((BiFunction[])functions);
        this.requireEmpty = requireEmpty;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        block3: {
            block2: {
                if (!this.requireEmpty) break block2;
                if (!generatedLoot.isEmpty()) break block3;
            }
            Consumer consumer = ILootFunction.func_215858_a(this.combinedFunctions, generatedLoot::add, (LootContext)context);
            this.entry.expand(context, generator -> generator.func_216188_a(consumer, context));
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddEntryLootModifier> {
        public AddEntryLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            LootEntry entry = (LootEntry)GSON.fromJson((JsonElement)JSONUtils.func_152754_s((JsonObject)object, (String)"entry"), LootEntry.class);
            ILootFunction[] functions = object.has("functions") ? (ILootFunction[])GSON.fromJson((JsonElement)JSONUtils.func_151214_t((JsonObject)object, (String)"functions"), ILootFunction[].class) : new ILootFunction[]{};
            boolean requireEmpty = JSONUtils.func_151209_a((JsonObject)object, (String)"require_empty", (boolean)false);
            return new AddEntryLootModifier(conditions, entry, functions, requireEmpty);
        }

        public JsonObject write(AddEntryLootModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            object.addProperty("require_empty", Boolean.valueOf(instance.requireEmpty));
            object.add("entry", GSON.toJsonTree((Object)instance.entry, LootEntry.class));
            object.add("functions", GSON.toJsonTree((Object)instance.functions, ILootFunction[].class));
            return object;
        }
    }
}

