/*
 * Decompiled with CFR 0.152.
 */
package de.univrsal.justenoughbuttons.core.network;

import de.univrsal.justenoughbuttons.core.network.IMessage;
import de.univrsal.justenoughbuttons.core.network.MessageSerializer;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final int PROTOCOL = 1;
    public final SimpleChannel channel;
    private int i = 0;

    public NetworkHandler() {
        String protocol = Integer.toString(1);
        this.channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("justenoughbuttons", "main")).networkProtocolVersion(() -> protocol).clientAcceptedVersions(protocol::equals).serverAcceptedVersions(protocol::equals).simpleChannel();
    }

    public <T extends IMessage> void register(Class<T> clazz, NetworkDirection dir) {
        BiConsumer<IMessage, PacketBuffer> encoder = (msg, buf) -> MessageSerializer.writeObject(msg, buf);
        Function<PacketBuffer, IMessage> decoder = buf -> {
            try {
                IMessage msg = (IMessage)clazz.newInstance();
                MessageSerializer.readObject(msg, buf);
                return msg;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        };
        BiConsumer<IMessage, Supplier> consumer = (msg, supp) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)supp.get();
            if (context.getDirection() != dir) {
                return;
            }
            context.setPacketHandled(msg.receive(context));
        };
        this.channel.registerMessage(this.i, clazz, encoder, decoder, consumer);
        ++this.i;
    }

    public void sendToPlayer(IMessage msg, ServerPlayerEntity player) {
        this.channel.sendTo((Object)msg, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void sendToServer(IMessage msg) {
        this.channel.sendToServer((Object)msg);
    }
}

