/*
 * Decompiled with CFR 0.152.
 */
package de.univrsal.justenoughbuttons.core.network;

import de.univrsal.justenoughbuttons.core.handlers.ConfigHandler;
import de.univrsal.justenoughbuttons.core.network.IMessage;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageExecuteButton
implements IMessage {
    public static final byte GM_CREATIVE = 0;
    public static final byte GM_ADVENTURE = 1;
    public static final byte GM_SURVIVAL = 2;
    public static final byte GM_SPECTATE = 3;
    public static final byte DELETE = 4;
    public static final byte RAIN = 5;
    public static final byte SUN = 6;
    public static final byte DAY = 7;
    public static final byte NIGHT = 8;
    public static final byte FREEZE = 9;
    public static final byte KILL = 10;
    public static final byte MAGNET = 11;
    public static final byte DELETE_ALL = 12;
    public int commandOrdinal;
    public String[] cmd;

    public MessageExecuteButton() {
    }

    public MessageExecuteButton(int cmdId, String[] cmd) {
        String[] stringArray;
        this.commandOrdinal = cmdId;
        if (cmd != null) {
            stringArray = cmd;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        this.cmd = stringArray;
    }

    public static boolean checkPermissions(ServerPlayerEntity player, MinecraftServer server) {
        if (server.func_71264_H()) {
            return true;
        }
        return server.func_110455_j() == server.func_211833_a(player.func_146103_bH());
    }

    @Override
    public boolean receive(NetworkEvent.Context context) {
        ServerPlayerEntity p = context.getSender();
        if (p == null) {
            return false;
        }
        ServerWorld world = p.func_71121_q();
        MinecraftServer s = p.field_71133_b;
        WorldInfo worldinfo = world.func_72912_H();
        boolean isOP = MessageExecuteButton.checkPermissions(p, s);
        boolean error = true;
        switch (this.commandOrdinal) {
            case 1: {
                if (!isOP && ConfigHandler.gamemodeRequiresOP) break;
                error = false;
                p.func_71033_a(GameType.ADVENTURE);
                break;
            }
            case 0: {
                if (!isOP && ConfigHandler.gamemodeRequiresOP) break;
                error = false;
                p.func_71033_a(GameType.CREATIVE);
                break;
            }
            case 2: {
                if (!isOP && ConfigHandler.gamemodeRequiresOP) break;
                error = false;
                p.func_71033_a(GameType.SURVIVAL);
                break;
            }
            case 3: {
                if (!isOP && ConfigHandler.gamemodeRequiresOP) break;
                error = false;
                p.func_71033_a(GameType.SPECTATOR);
                break;
            }
            case 12: {
                if (!isOP && ConfigHandler.deleteRequiresOP) break;
                error = false;
                p.field_71071_by.func_174888_l();
                break;
            }
            case 4: {
                if (!isOP && ConfigHandler.deleteRequiresOP) break;
                error = false;
                p.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                break;
            }
            case 6: {
                if (!isOP && ConfigHandler.weatherRequiresOP) break;
                error = false;
                worldinfo.func_176142_i(1000000);
                worldinfo.func_76080_g(0);
                worldinfo.func_76090_f(0);
                worldinfo.func_76084_b(false);
                worldinfo.func_76069_a(false);
                break;
            }
            case 5: {
                if (!isOP && ConfigHandler.weatherRequiresOP) break;
                error = false;
                worldinfo.func_176142_i(0);
                worldinfo.func_76080_g(1000000);
                worldinfo.func_76090_f(1000000);
                worldinfo.func_76084_b(true);
                worldinfo.func_76069_a(false);
                break;
            }
            case 7: {
                if (!isOP && ConfigHandler.timeRequiresOP) break;
                error = false;
                worldinfo.func_76068_b(1000L);
                break;
            }
            case 8: {
                if (!isOP && ConfigHandler.timeRequiresOP) break;
                error = false;
                world.func_72877_b(13000L);
                break;
            }
            case 9: {
                if (!isOP && ConfigHandler.timeFreezeRequiresOP) break;
                error = false;
                boolean origValue = worldinfo.func_82574_x().func_223586_b(GameRules.field_223607_j);
                ((GameRules.BooleanValue)worldinfo.func_82574_x().func_223585_a(GameRules.field_223607_j)).func_223570_a(!origValue, s);
                break;
            }
            case 10: {
                if (!isOP && ConfigHandler.killMobsRequiresOP) break;
                error = false;
                Iterator e = world.getEntities().iterator();
                while (e.hasNext()) {
                    Entity entity = (Entity)e.next();
                    if ((entity instanceof PlayerEntity || !(entity instanceof LivingEntity)) && !(entity instanceof ItemEntity)) continue;
                    world.func_217467_h(entity);
                }
                break;
            }
        }
        if (error) {
            TranslationTextComponent msg = new TranslationTextComponent("commands.help.failed", new Object[0]);
            msg.func_150255_a(msg.func_150256_b().func_150238_a(TextFormatting.RED));
            p.func_145747_a((ITextComponent)msg);
        }
        return !error;
    }
}

