/*
 * Decompiled with CFR 0.152.
 */
package de.univrsal.justenoughbuttons.client.handlers;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.univrsal.justenoughbuttons.JEIButtons;
import de.univrsal.justenoughbuttons.client.ClientProxy;
import de.univrsal.justenoughbuttons.client.handlers.InventorySaveHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;

public class SaveFileHandler {
    public static boolean SAVE_SNAPSHOTS = true;
    private static boolean HAS_LOADED = false;
    private static String savePath;

    public SaveFileHandler init() {
        savePath = ClientProxy.mc.field_71412_D.toString() + "/mods/JustEnoughButtons";
        File saveFolder = new File(savePath);
        if (!saveFolder.exists()) {
            JEIButtons.logInfo("No save folder for inventory snapshots found. Creating it under %s", savePath);
            if (!saveFolder.mkdir()) {
                JEIButtons.logInfo("Couldn't create folder. Saving of inventory snapshots is disabled!", new Object[0]);
                SAVE_SNAPSHOTS = false;
            }
        }
        return this;
    }

    public void loadForPlayer() throws FileNotFoundException {
        if (HAS_LOADED) {
            return;
        }
        HAS_LOADED = true;
        UUID uuid = PlayerEntity.func_146094_a((GameProfile)Minecraft.func_71410_x().func_110432_I().func_148256_e());
        File saveFolder = new File(savePath);
        File saveFile = null;
        if (uuid != null) {
            for (File f : saveFolder.listFiles()) {
                if (!f.getName().contains(uuid.toString())) continue;
                saveFile = f;
                break;
            }
        }
        if (saveFile != null) {
            JEIButtons.logInfo("Found savefile for user!", new Object[0]);
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(saveFile));
                CompoundNBT[] mainInventory = new CompoundNBT[36];
                CompoundNBT[] armorInventory = new CompoundNBT[4];
                CompoundNBT offHand = new CompoundNBT();
                CompoundNBT icon = new CompoundNBT();
                int invIndex = 0;
                int armorIndex = 0;
                int saveIndex = 0;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("MainInv:")) {
                        mainInventory[invIndex] = JsonToNBT.func_180713_a((String)line.substring(8));
                        ++invIndex;
                        continue;
                    }
                    if (line.startsWith("NullInv")) {
                        ++invIndex;
                        continue;
                    }
                    if (line.startsWith("ArmoInv:")) {
                        armorInventory[armorIndex] = JsonToNBT.func_180713_a((String)line.substring(8));
                        ++armorIndex;
                        continue;
                    }
                    if (line.startsWith("NullArm")) {
                        ++armorIndex;
                        continue;
                    }
                    if (line.startsWith("OffHand:")) {
                        offHand = JsonToNBT.func_180713_a((String)line.substring(8));
                        continue;
                    }
                    if (line.startsWith("IconSta:")) {
                        icon = JsonToNBT.func_180713_a((String)line.substring(8));
                        continue;
                    }
                    if (line.startsWith("EMPTY SAVE")) {
                        ++saveIndex;
                        continue;
                    }
                    if (line.startsWith("END SAVE")) {
                        InventorySaveHandler.saves[saveIndex] = new InventorySaveHandler.InventorySnapshot(icon.func_74737_b(), (CompoundNBT[])mainInventory.clone(), (CompoundNBT[])armorInventory.clone(), offHand.func_74737_b());
                        ++saveIndex;
                        invIndex = 0;
                        armorIndex = 0;
                        mainInventory = new CompoundNBT[36];
                        armorInventory = new CompoundNBT[4];
                        offHand = new CompoundNBT();
                        icon = new CompoundNBT();
                        continue;
                    }
                    if (!line.startsWith("EOF")) continue;
                }
            }
            catch (CommandSyntaxException | IOException e) {
                e.printStackTrace();
            }
        } else {
            JEIButtons.logInfo("No save file available.", new Object[0]);
        }
    }

    public void saveForPlayer() throws FileNotFoundException, UnsupportedEncodingException {
        if (ClientProxy.player == null) {
            JEIButtons.logInfo("Error when saving inventory saves player instance is null!", new Object[0]);
            return;
        }
        UUID uuid = PlayerEntity.func_146094_a((GameProfile)ClientProxy.player.func_146103_bH());
        File oldFile = new File(savePath + "/" + uuid + ".jebs");
        if (oldFile.exists() && !oldFile.delete()) {
            JEIButtons.logInfo("Error deleting old snapshot save. Saving of inventory snapshots will not be available!", new Object[0]);
            SAVE_SNAPSHOTS = false;
        }
        File saveFile = new File(savePath + "/" + uuid + ".jebs");
        PrintWriter writer = new PrintWriter(saveFile, "UTF-8");
        writer.println("# JustEnoughButtons Save file for " + ClientProxy.player.func_145748_c_() + ", " + uuid.toString());
        writer.println("# Created " + new Date(System.currentTimeMillis()));
        writer.println("# WARNING: Modifying this file might result in crashes!");
        for (int i = 0; i < 4; ++i) {
            InventorySaveHandler.InventorySnapshot snapshot = InventorySaveHandler.saves[i];
            if (snapshot != null) {
                for (CompoundNBT nbt : snapshot.mainInventory) {
                    if (nbt != null) {
                        writer.println("MainInv:" + nbt.toString());
                        continue;
                    }
                    writer.println("NullInv");
                }
                for (CompoundNBT c : snapshot.armorInventory) {
                    if (c != null) {
                        writer.println("ArmoInv:" + c.toString());
                        continue;
                    }
                    writer.println("NullArm");
                }
                if (snapshot.icon != null) {
                    CompoundNBT icon = new CompoundNBT();
                    snapshot.icon.func_77955_b(icon);
                    if (!icon.isEmpty()) {
                        writer.println("IconSta:" + icon.toString());
                    }
                }
                if (snapshot.offHandInventory != null) {
                    writer.println("OffHand:" + snapshot.offHandInventory.toString());
                }
                writer.println("END SAVE");
                continue;
            }
            writer.println("EMPTY SAVE");
        }
        writer.println("EOF");
        writer.close();
    }
}

