/*
 * Decompiled with CFR 0.152.
 */
package de.univrsal.justenoughbuttons.client.handlers;

import de.univrsal.justenoughbuttons.JEIButtons;
import de.univrsal.justenoughbuttons.client.ClientProxy;
import de.univrsal.justenoughbuttons.client.ClientUtil;
import de.univrsal.justenoughbuttons.client.gui.SaveButton;
import de.univrsal.justenoughbuttons.core.CommonProxy;
import de.univrsal.justenoughbuttons.core.handlers.ConfigHandler;
import de.univrsal.justenoughbuttons.core.network.MessageRequestStacks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class InventorySaveHandler {
    private static SaveButton[] saveButtons = new SaveButton[4];
    static InventorySnapshot[] saves = new InventorySnapshot[4];
    private static final String replaceCommand = "replaceitem entity @p %s %s%s %s";

    public static void init() {
        String load = I18n.func_135052_a((String)"justenoughbuttons.load", (Object[])new Object[0]) + " ";
        String save = I18n.func_135052_a((String)"justenoughbuttons.save", (Object[])new Object[0]) + " ";
        for (int i = 0; i < saveButtons.length; ++i) {
            InventorySaveHandler.saveButtons[i] = new SaveButton(i, ConfigHandler.xOffset, 110 + ConfigHandler.yOffset + 22 * i, 50, 20, (saves[i] == null ? save : load) + (i + 1), (btn, mousebtn) -> {
                if (mousebtn == 0) {
                    if (saves[btn.id] == null) {
                        InventorySaveHandler.saves[btn.id] = new InventorySnapshot(ClientProxy.player.field_71071_by);
                        saveButtons[btn.id].setMessage(load + (btn.id + 1));
                    } else if (!ClientProxy.player.field_71071_by.func_70445_o().func_190926_b()) {
                        InventorySaveHandler.saves[btn.id].icon = ClientProxy.player.field_71071_by.func_70445_o().func_77946_l();
                    } else {
                        saves[btn.id].giveToPlayer();
                    }
                } else {
                    InventorySaveHandler.saves[btn.id] = null;
                    saveButtons[btn.id].setMessage(save + (btn.id + 1));
                }
            });
        }
    }

    static void click(int mouseX, int mouseY, int mousebutton) {
        block6: {
            block7: {
                if (mousebutton != 0) break block7;
                for (int i = 0; i < saveButtons.length; ++i) {
                    if (!saveButtons[i].mouseClicked(mouseX, mouseY, mousebutton)) continue;
                    if (saves[i] == null) {
                        InventorySaveHandler.saves[i] = new InventorySnapshot(ClientProxy.player.field_71071_by);
                        String load = I18n.func_135052_a((String)"justenoughbuttons.load", (Object[])new Object[0]) + " ";
                        saveButtons[i].setMessage(load + (i + 1));
                    } else if (!ClientProxy.player.field_71071_by.func_70445_o().func_190926_b()) {
                        InventorySaveHandler.saves[i].icon = ClientProxy.player.field_71071_by.func_70445_o().func_77946_l();
                    } else {
                        saves[i].giveToPlayer();
                    }
                    break block6;
                }
                break block6;
            }
            if (mousebutton != 1) break block6;
            for (int i = 0; i < saveButtons.length; ++i) {
                if (!saveButtons[i].mouseClicked(mouseX, mouseY, mousebutton)) continue;
                InventorySaveHandler.saves[i] = null;
                String save = I18n.func_135052_a((String)"justenoughbuttons.save", (Object[])new Object[0]) + " ";
                saveButtons[i].setMessage(save + (i + 1));
                break;
            }
        }
    }

    static void drawButtons(int mouseX, int mouseY) {
        for (SaveButton s : saveButtons) {
            s.render(mouseX, mouseY, 0.0f);
            s.func_212927_b(ClientUtil.mc.field_71417_B.func_198024_e(), ClientUtil.mc.field_71417_B.func_198026_f());
            if (saves[s.id] == null || InventorySaveHandler.saves[s.id].icon == null) continue;
            RenderHelper.func_74519_b();
            RenderHelper.func_74520_c();
            ClientProxy.mc.func_175599_af().func_180450_b(InventorySaveHandler.saves[s.id].icon, s.x + s.getWidth() + 2, s.y + 2);
            RenderHelper.func_74518_a();
        }
    }

    static class InventorySnapshot {
        ItemStack icon;
        CompoundNBT[] mainInventory;
        CompoundNBT[] armorInventory;
        CompoundNBT offHandInventory;

        InventorySnapshot(CompoundNBT icon, CompoundNBT[] mainInventory, CompoundNBT[] armorInventory, CompoundNBT offHandInventory) {
            this.icon = ItemStack.func_199557_a((CompoundNBT)icon);
            this.mainInventory = mainInventory;
            this.armorInventory = armorInventory;
            this.offHandInventory = offHandInventory;
        }

        InventorySnapshot(PlayerInventory inv) {
            CompoundNBT nbt;
            int i;
            this.mainInventory = new CompoundNBT[inv.field_70462_a.size()];
            this.armorInventory = new CompoundNBT[inv.field_70460_b.size()];
            this.offHandInventory = new CompoundNBT();
            for (i = 0; i < inv.field_70462_a.size(); ++i) {
                nbt = new CompoundNBT();
                ((ItemStack)inv.field_70462_a.get(i)).func_77955_b(nbt);
                this.mainInventory[i] = nbt;
            }
            for (i = 0; i < inv.field_70460_b.size(); ++i) {
                nbt = new CompoundNBT();
                ((ItemStack)inv.field_70460_b.get(i)).func_77955_b(nbt);
                this.armorInventory[i] = nbt;
            }
            CompoundNBT nbt2 = new CompoundNBT();
            ((ItemStack)inv.field_184439_c.get(0)).func_77955_b(nbt2);
            this.offHandInventory = nbt2;
        }

        void giveToPlayer() {
            if (!JEIButtons.isServerSidePresent) {
                ItemStack s;
                String cmd;
                String nbt;
                ItemStack s2;
                int i;
                JEIButtons.sendCommand("clear");
                for (i = 0; i < this.mainInventory.length; ++i) {
                    if (this.mainInventory[i] == null || (s2 = ItemStack.func_199557_a((CompoundNBT)this.mainInventory[i])).func_190926_b()) continue;
                    nbt = s2.func_77942_o() ? s2.func_77978_p().toString() : "";
                    cmd = i < 9 ? String.format(InventorySaveHandler.replaceCommand, "hotbar." + i, s2.func_77973_b().getRegistryName(), nbt, s2.func_190916_E()) : String.format(InventorySaveHandler.replaceCommand, "inventory." + (i - 9), s2.func_77973_b().getRegistryName(), nbt, s2.func_190916_E());
                    if (!this.checkCommandLength(cmd)) continue;
                    JEIButtons.sendCommand(cmd);
                }
                for (i = 0; i < this.armorInventory.length; ++i) {
                    if (this.armorInventory[i] == null || (s2 = ItemStack.func_199557_a((CompoundNBT)this.armorInventory[i])).func_190926_b()) continue;
                    nbt = s2.func_77942_o() ? s2.func_77978_p().toString() : "";
                    cmd = String.format(InventorySaveHandler.replaceCommand, "armor." + this.idToSlot(i), s2.func_77973_b().getRegistryName(), nbt, s2.func_190916_E());
                    if (!this.checkCommandLength(cmd)) continue;
                    JEIButtons.sendCommand(cmd);
                }
                if (this.offHandInventory != null && !(s = ItemStack.func_199557_a((CompoundNBT)this.offHandInventory)).func_190926_b()) {
                    nbt = s.func_77942_o() ? s.func_77978_p().toString() : "";
                    cmd = String.format(InventorySaveHandler.replaceCommand, "weapon.offhand", s.func_77973_b().getRegistryName(), nbt, s.func_190916_E());
                    if (this.checkCommandLength(cmd)) {
                        JEIButtons.sendCommand(cmd);
                    }
                }
            } else {
                CommonProxy.network.sendToServer(new MessageRequestStacks(this.mainInventory, this.armorInventory, this.offHandInventory));
            }
            ClientProxy.player.field_71071_by.func_70296_d();
        }

        boolean checkCommandLength(String cmd) {
            if (cmd.length() > 100) {
                ClientProxy.player.func_145747_a((ITextComponent)new TranslationTextComponent("justenoughbuttons.nbttoolong", new Object[0]));
                return false;
            }
            return true;
        }

        String idToSlot(int i) {
            switch (i) {
                case 0: {
                    return "feet";
                }
                case 1: {
                    return "legs";
                }
                case 2: {
                    return "chest";
                }
                case 3: {
                    return "head";
                }
            }
            return "head";
        }
    }
}

