/*
 * Decompiled with CFR 0.152.
 */
package de.univrsal.justenoughbuttons.client;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.fluid.IFluidState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.lighting.IWorldLightListener;
import org.lwjgl.opengl.GL11;

public class MobOverlayRenderer {
    private static Map<BlockPos, SpawnType> cache = new HashMap<BlockPos, SpawnType>();

    public static void renderMobSpawnOverlay() {
        ActiveRenderInfo ai = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        GlStateManager.pushMatrix();
        GlStateManager.disableBlend();
        GlStateManager.disableLighting();
        GlStateManager.disableTexture();
        GlStateManager.translated((double)(-ai.func_216785_c().field_72450_a), (double)(-ai.func_216785_c().field_72448_b), (double)(-ai.func_216785_c().field_72449_c));
        GL11.glLineWidth((float)1.5f);
        GlStateManager.color3f((float)1.0f, (float)0.0f, (float)0.0f);
        for (BlockPos p : cache.keySet()) {
            SpawnType t = cache.get(p);
            if (t == SpawnType.ALWAYS) {
                MobOverlayRenderer.renderCross(p, 1.0f, 0.0f, 0.0f);
                continue;
            }
            MobOverlayRenderer.renderCross(p, 1.0f, 1.0f, 0.0f);
        }
        GlStateManager.enableLighting();
        GlStateManager.enableTexture();
        GlStateManager.enableBlend();
        GlStateManager.popMatrix();
    }

    private static void renderCross(BlockPos pos, float r, float g, float b) {
        double y = (double)pos.func_177956_o() + 0.005;
        double x0 = pos.func_177958_n();
        double x1 = x0 + 1.0;
        double z0 = pos.func_177952_p();
        double z1 = z0 + 1.0;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder renderer = tess.func_178180_c();
        renderer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b(x0, y, z0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x1, y, z1).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x1, y, z0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x0, y, z1).func_181666_a(r, g, b, 1.0f).func_181675_d();
        tess.func_78381_a();
    }

    public static void cacheMobSpawns(Entity entity) {
        cache.clear();
        World world = entity.field_70170_p;
        int entX = (int)entity.field_70165_t;
        int entY = MathHelper.func_76125_a((int)((int)entity.field_70163_u), (int)16, (int)(world.func_217301_I() - 16));
        int entZ = (int)entity.field_70161_v;
        for (int x = entX - 16; x <= entX + 16; ++x) {
            for (int z = entZ - 16; z <= entZ + 16; ++z) {
                BlockPos pos = new BlockPos(x, entY, z);
                IChunk chunk = world.func_217349_x(pos);
                Biome biome = world.func_180494_b(pos);
                if (biome.func_76747_a(EntityClassification.MONSTER).isEmpty() || biome.func_76741_f() <= 0.0f) continue;
                for (int y = entY - 16; y < entY + 16; ++y) {
                    SpawnType spawnType;
                    if (!world.func_175623_d(new BlockPos(x, y, z)) || (spawnType = MobOverlayRenderer.getSpawnType((IWorldReader)world, chunk, x, y, z)) == SpawnType.NEVER) continue;
                    cache.put(new BlockPos(x, y, z), spawnType);
                }
            }
        }
    }

    private static SpawnType getSpawnType(IWorldReader w, IChunk chunk, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        BlockState bs = w.func_180495_p(pos);
        IFluidState fs = w.func_204610_c(pos);
        IWorldLightListener ble = Objects.requireNonNull(chunk.func_217307_e()).func_215569_a(LightType.BLOCK);
        int block_light = ble.func_215611_b(pos);
        World world = (World)w;
        if (!EntitySpawnPlacementRegistry.PlacementType.ON_GROUND.canSpawnAt(w, pos, null) || block_light >= 8) {
            return SpawnType.NEVER;
        }
        AxisAlignedBB aabb = new AxisAlignedBB(pos);
        VoxelShape vs = VoxelShapes.func_197881_a((AxisAlignedBB)aabb);
        if (!w.func_195585_a(null, vs) || !world.func_72839_b(null, aabb).isEmpty() || world.func_72953_d(aabb)) {
            return SpawnType.NEVER;
        }
        if (w.func_175710_j(pos)) {
            return SpawnType.NIGHT_ONLY;
        }
        return SpawnType.ALWAYS;
    }

    public static void clearCache() {
        cache.clear();
    }

    private static enum SpawnType {
        NEVER,
        NIGHT_ONLY,
        ALWAYS;

    }
}

