/*
 * Decompiled with CFR 0.152.
 */
package de.universallp.justenoughbuttons.core;

import com.mojang.realmsclient.gui.ChatFormatting;
import de.universallp.justenoughbuttons.JEIButtons;
import de.universallp.justenoughbuttons.client.ClientProxy;
import de.universallp.justenoughbuttons.client.MobOverlayRenderer;
import de.universallp.justenoughbuttons.core.CommonProxy;
import de.universallp.justenoughbuttons.core.InventorySaveHandler;
import de.universallp.justenoughbuttons.core.MessageMagnetMode;
import de.universallp.justenoughbuttons.core.MessageNotifyClient;
import de.universallp.justenoughbuttons.core.SaveFileHandler;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class EventHandlers {
    private static boolean gameRuleDayCycle = false;
    private boolean isLMBDown = false;
    private boolean isRMBDown = false;
    private static BlockPos lastPlayerPos = null;
    private boolean drawMobOverlay = false;
    private boolean magnetMode = false;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent e) {
        if (JEIButtons.isAnyButtonHovered && JEIButtons.ConfigHandler.showButtons && e.getGui() != null && e.getGui() instanceof GuiContainer) {
            int mouseY = JEIButtons.proxy.getMouseY();
            int mouseX = JEIButtons.proxy.getMouseX();
            List<String> tip = this.getTooltip(JEIButtons.hoveredButton);
            if (tip != null) {
                GuiUtils.drawHoveringText(tip, (int)mouseX, (int)(mouseY < 17 ? 17 : mouseY), (int)ClientProxy.mc.field_71443_c, (int)ClientProxy.mc.field_71440_d, (int)-1, (FontRenderer)ClientProxy.mc.field_71466_p);
                RenderHelper.func_74518_a();
            }
        }
        if (e.getGui() instanceof GuiConfig) {
            GuiConfigEntries eL = ((GuiConfig)e.getGui()).entryList;
            GuiConfig cfg = (GuiConfig)e.getGui();
            if (cfg.titleLine2 != null && cfg.titleLine2.equals("position")) {
                int y = EventHandlers.getInt(1, eL);
                int x = EventHandlers.getInt(0, eL);
                GuiUtils.drawGradientRect((int)10, (int)x, (int)y, (int)(x + 75), (int)(y + 75), (int)0x77888888, (int)0x77888888);
                ClientProxy.mc.field_71466_p.func_78276_b("[Buttons]", x + 14, y + 10, 0xFFFFFF);
            }
        }
    }

    private static int getInt(int i, GuiConfigEntries eL) {
        if (i < eL.func_148127_b() && eL.getListEntry(i) != null && String.valueOf(eL.getListEntry(i).getCurrentValue()).length() > 0 && String.valueOf(eL.getListEntry(i).getCurrentValue()).length() < 5 && !String.valueOf(eL.getListEntry(i).getCurrentValue()).equals("-")) {
            return Integer.valueOf(String.valueOf(eL.getListEntry(i).getCurrentValue()));
        }
        return -1;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawBackgroundEventPost(GuiScreenEvent.BackgroundDrawnEvent e) {
        if (JEIButtons.configHasChanged) {
            JEIButtons.configHasChanged = false;
            JEIButtons.setUpPositions();
        }
        if (JEIButtons.isServerSidePresent && e.getGui() instanceof GuiMainMenu) {
            JEIButtons.isServerSidePresent = false;
        } else if (JEIButtons.ConfigHandler.showButtons && e.getGui() != null && e.getGui() instanceof GuiContainer) {
            int mouseY = JEIButtons.proxy.getMouseY();
            int mouseX = JEIButtons.proxy.getMouseX();
            GuiContainer g = (GuiContainer)e.getGui();
            EntityPlayerSP pl = ClientProxy.player;
            if (JEIButtons.btnGameMode == JEIButtons.EnumButtonCommands.SPECTATE && !JEIButtons.ConfigHandler.enableSpectatoreMode || JEIButtons.btnGameMode == JEIButtons.EnumButtonCommands.ADVENTURE && !JEIButtons.ConfigHandler.enableAdventureMode) {
                JEIButtons.btnGameMode = JEIButtons.btnGameMode.cycle();
            }
            JEIButtons.isAnyButtonHovered = false;
            gameRuleDayCycle = ClientProxy.mc.field_71441_e.func_82736_K().func_82766_b("doDaylightCycle");
            JEIButtons.btnGameMode.draw(g);
            JEIButtons.btnTrash.draw(g);
            JEIButtons.btnSun.draw(g);
            JEIButtons.btnRain.draw(g);
            JEIButtons.btnDay.draw(g);
            JEIButtons.btnNight.draw(g);
            JEIButtons.btnNoMobs.draw(g);
            JEIButtons.btnFreeze.draw(g);
            JEIButtons.btnMagnet.draw(g);
            if (JEIButtons.ConfigHandler.enableSaves) {
                InventorySaveHandler.drawButtons(mouseX, mouseY);
            }
            for (JEIButtons.EnumButtonCommands btn : JEIButtons.btnCustom) {
                btn.draw(g);
            }
            this.adjustGamemode();
            if (Mouse.isButtonDown((int)0) && !this.isLMBDown) {
                this.isLMBDown = true;
                if (JEIButtons.isAnyButtonHovered && JEIButtons.hoveredButton.isEnabled) {
                    String command = "/" + JEIButtons.hoveredButton.getCommand();
                    if (JEIButtons.hoveredButton == JEIButtons.EnumButtonCommands.FREEZETIME) {
                        command = command + " " + (gameRuleDayCycle ? "false" : "true");
                    }
                    if (JEIButtons.hoveredButton == JEIButtons.EnumButtonCommands.DELETE) {
                        ItemStack draggedStack = pl.field_71071_by.func_70445_o();
                        if (draggedStack.func_190926_b()) {
                            command = GuiScreen.func_146272_n() && JEIButtons.ConfigHandler.enableClearInventory ? "/clear" : null;
                        } else {
                            boolean ghost;
                            String name = draggedStack.func_77973_b().getRegistryName().toString();
                            command = command + pl.func_145748_c_().func_150260_c() + " " + name;
                            if (!GuiScreen.func_146272_n()) {
                                int data = draggedStack.func_77952_i();
                                command = command + " " + data;
                            }
                            boolean bl = ghost = draggedStack.func_77942_o() && draggedStack.func_77978_p().func_74767_n("JEI_Ghost");
                            if (ghost) {
                                pl.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                            }
                        }
                    }
                    if (JEIButtons.hoveredButton == JEIButtons.EnumButtonCommands.MAGNET) {
                        if (JEIButtons.isServerSidePresent) {
                            command = null;
                            CommonProxy.INSTANCE.sendToServer((IMessage)new MessageMagnetMode(this.magnetMode));
                            this.magnetMode = !this.magnetMode;
                        } else {
                            command = "/tp @e[type=Item,r=" + JEIButtons.ConfigHandler.magnetRadius + "] @p";
                        }
                    }
                    if (command != null) {
                        pl.func_71165_d(command);
                    }
                    JEIButtons.proxy.playClick();
                    if (JEIButtons.hoveredButton.ordinal() < 4) {
                        JEIButtons.btnGameMode = JEIButtons.hoveredButton.cycle();
                    }
                } else if (JEIButtons.ConfigHandler.enableSaves && InventorySaveHandler.click(mouseX, mouseY, false)) {
                    JEIButtons.proxy.playClick();
                }
            } else if (!Mouse.isButtonDown((int)0)) {
                this.isLMBDown = false;
            }
            if (Mouse.isButtonDown((int)1) && !this.isRMBDown) {
                this.isRMBDown = true;
                if (InventorySaveHandler.click(mouseX, mouseY, true)) {
                    JEIButtons.proxy.playClick();
                }
            } else if (!Mouse.isButtonDown((int)1)) {
                this.isRMBDown = false;
            }
        }
    }

    private void adjustGamemode() {
        GameType t = ClientProxy.mc.field_71442_b.func_178889_l();
        boolean doSwitch = false;
        if (t == GameType.CREATIVE && JEIButtons.btnGameMode == JEIButtons.EnumButtonCommands.CREATIVE) {
            doSwitch = true;
        } else if (t == GameType.SURVIVAL && JEIButtons.btnGameMode == JEIButtons.EnumButtonCommands.SURVIVAL) {
            doSwitch = true;
        } else if (t == GameType.ADVENTURE && JEIButtons.btnGameMode == JEIButtons.EnumButtonCommands.ADVENTURE) {
            doSwitch = true;
        } else if (t == GameType.SPECTATOR && JEIButtons.btnGameMode == JEIButtons.EnumButtonCommands.SPECTATE) {
            doSwitch = true;
        }
        if (doSwitch) {
            JEIButtons.btnGameMode = JEIButtons.btnGameMode.cycle();
        }
    }

    @SubscribeEvent
    public void onWorldJoin(EntityJoinWorldEvent e) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            InventorySaveHandler.init();
            if (e.getEntity() instanceof EntityPlayer) {
                ClientProxy.player = FMLClientHandler.instance().getClientPlayerEntity();
                JEIButtons.btnGameMode = ((EntityPlayer)e.getEntity()).field_71075_bZ.field_75098_d ? JEIButtons.btnGameMode.cycle() : JEIButtons.EnumButtonCommands.CREATIVE;
            }
        } else if (e.getEntity() != null && e.getEntity() instanceof EntityPlayerMP) {
            CommonProxy.INSTANCE.sendTo((IMessage)new MessageNotifyClient(), (EntityPlayerMP)e.getEntity());
        }
    }

    @SubscribeEvent
    public void onWorldLeave(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (SaveFileHandler.SAVE_SNAPSHOTS) {
            try {
                ClientProxy.saveHandler.saveForPlayer();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void handleKeyInputEvent(GuiScreenEvent.KeyboardInputEvent.Post e) {
        GuiScreen gui = ClientProxy.mc.field_71462_r;
        if (gui != null && gui instanceof GuiContainer) {
            int keyCode = Keyboard.getEventKey();
            if (ClientProxy.makeCopyKey.isActiveAndMatches(keyCode)) {
                Slot hovered = ((GuiContainer)gui).getSlotUnderMouse();
                if (hovered != null && ClientProxy.player.field_71071_by.func_70445_o().func_190926_b() && !hovered.func_75211_c().func_190926_b() && hovered.func_75216_d()) {
                    ItemStack stack = hovered.func_75211_c().func_77946_l();
                    stack.func_190920_e(1);
                    NBTTagCompound t = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
                    t.func_74757_a("JEI_Ghost", true);
                    stack.func_77982_d(t);
                    ClientProxy.player.field_71071_by.func_70437_b(stack);
                }
            } else if (Keyboard.isKeyDown((int)ClientProxy.hideall.func_151463_i()) && !Keyboard.isRepeatEvent()) {
                JEIButtons.ConfigHandler.showButtons = !JEIButtons.ConfigHandler.showButtons;
            }
        }
    }

    @SubscribeEvent
    public void onMouseEvent(GuiScreenEvent.MouseInputEvent event) {
        if (Mouse.getEventButton() == 0) {
            if (JEIButtons.isAnyButtonHovered && JEIButtons.hoveredButton == JEIButtons.EnumButtonCommands.DELETE && !ClientProxy.player.field_71071_by.func_70445_o().equals(ItemStack.field_190927_a)) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            }
            if (InventorySaveHandler.skipClick) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.KeyInputEvent event) {
        if (JEIButtons.enableOverlays) {
            if (ClientProxy.mobOverlay.func_151470_d()) {
                boolean bl = this.drawMobOverlay = !this.drawMobOverlay;
            }
            if (!this.drawMobOverlay) {
                MobOverlayRenderer.clearCache();
                lastPlayerPos = null;
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!(FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT || lastPlayerPos != null && lastPlayerPos.equals((Object)ClientProxy.player.func_180425_c()))) {
            if (this.drawMobOverlay) {
                MobOverlayRenderer.cacheMobSpawns((Entity)ClientProxy.player);
            }
            if (this.drawMobOverlay) {
                lastPlayerPos = ClientProxy.player.func_180425_c();
            }
        }
    }

    @SubscribeEvent
    public void onWorldDraw(RenderWorldLastEvent event) {
        if (this.drawMobOverlay) {
            MobOverlayRenderer.renderMobSpawnOverlay();
        }
        if (ClientProxy.mc.field_71462_r == null) {
            InventorySaveHandler.skipClick = false;
        }
    }

    public List<String> getTooltip(JEIButtons.EnumButtonCommands btn) {
        ArrayList<String> list = new ArrayList<String>();
        switch (btn) {
            case ADVENTURE: {
                list.add(I18n.func_135052_a((String)"justenoughbuttons.switchto", (Object[])new Object[]{I18n.func_135052_a((String)"gameMode.adventure", (Object[])new Object[0])}));
                break;
            }
            case CREATIVE: {
                list.add(I18n.func_135052_a((String)"justenoughbuttons.switchto", (Object[])new Object[]{I18n.func_135052_a((String)"gameMode.creative", (Object[])new Object[0])}));
                break;
            }
            case SPECTATE: {
                list.add(I18n.func_135052_a((String)"justenoughbuttons.switchto", (Object[])new Object[]{I18n.func_135052_a((String)"gameMode.spectator", (Object[])new Object[0])}));
                break;
            }
            case SURVIVAL: {
                list.add(I18n.func_135052_a((String)"justenoughbuttons.switchto", (Object[])new Object[]{I18n.func_135052_a((String)"gameMode.survival", (Object[])new Object[0])}));
                break;
            }
            case DAY: {
                list.add(I18n.func_135052_a((String)"justenoughbuttons.switchto", (Object[])new Object[]{I18n.func_135052_a((String)"justenoughbuttons.timeday", (Object[])new Object[0])}));
                break;
            }
            case NIGHT: {
                list.add(I18n.func_135052_a((String)"justenoughbuttons.switchto", (Object[])new Object[]{I18n.func_135052_a((String)"justenoughbuttons.timenight", (Object[])new Object[0])}));
                break;
            }
            case DELETE: {
                ItemStack draggedStack = ClientProxy.player.field_71071_by.func_70445_o();
                if (draggedStack != null) {
                    list.add(I18n.func_135052_a((String)"justenoughbuttons.deleteall", (Object[])new Object[]{I18n.func_135052_a((String)(draggedStack.func_77977_a() + ".name"), (Object[])new Object[0])}));
                    if (!GuiScreen.func_146272_n()) break;
                    list.add(ChatFormatting.GRAY + I18n.func_135052_a((String)"justenoughbuttons.ignoringmeta", (Object[])new Object[0]));
                    break;
                }
                list.add(I18n.func_135052_a((String)"justenoughbuttons.dragitemshere", (Object[])new Object[0]));
                list.add(ChatFormatting.GRAY + I18n.func_135052_a((String)"justenoughbuttons.holdshift", (Object[])new Object[0]));
                if (!JEIButtons.ConfigHandler.enableClearInventory) break;
                list.add(ChatFormatting.GRAY + I18n.func_135052_a((String)"justenoughbuttons.clearinventory", (Object[])new Object[0]));
                break;
            }
            case FREEZETIME: {
                if (gameRuleDayCycle) {
                    list.add(I18n.func_135052_a((String)"justenoughbuttons.freezetime", (Object[])new Object[0]));
                    break;
                }
                list.add(I18n.func_135052_a((String)"justenoughbuttons.unfreezetime", (Object[])new Object[0]));
                break;
            }
            case NOMOBS: {
                list.add(I18n.func_135052_a((String)"justenoughbuttons.nomobs", (Object[])new Object[0]));
                break;
            }
            case RAIN: {
                list.add(I18n.func_135052_a((String)"commands.weather.rain", (Object[])new Object[0]));
                break;
            }
            case SUN: {
                list.add(I18n.func_135052_a((String)"commands.weather.clear", (Object[])new Object[0]));
                break;
            }
            case MAGNET: {
                if (JEIButtons.isServerSidePresent) {
                    if (this.magnetMode) {
                        list.add(I18n.func_135052_a((String)"justenoughbuttons.magnet.off", (Object[])new Object[0]));
                        break;
                    }
                    list.add(I18n.func_135052_a((String)"justenoughbuttons.magnet.on", (Object[])new Object[0]));
                    break;
                }
                list.add(I18n.func_135052_a((String)"justenoughbuttons.magnetitems", (Object[])new Object[0]));
                break;
            }
            case CUSTOM1: 
            case CUSTOM2: 
            case CUSTOM3: 
            case CUSTOM4: {
                if (JEIButtons.ConfigHandler.customName[btn.id].equals("")) {
                    list.add(I18n.func_135052_a((String)"justenoughbuttons.customcommand", (Object[])new Object[]{"/" + JEIButtons.ConfigHandler.customCommand[btn.id]}));
                    break;
                }
                list.add(JEIButtons.ConfigHandler.customName[btn.id]);
            }
        }
        return list;
    }
}

