/*
 * Decompiled with CFR 0.152.
 */
package de.universallp.justenoughbuttons.core.network;

import de.universallp.justenoughbuttons.core.handlers.ConfigHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageExecuteButton
implements IMessage,
IMessageHandler<MessageExecuteButton, IMessage> {
    public static final byte GM_CREATIVE = 0;
    public static final byte GM_ADVENTURE = 1;
    public static final byte GM_SURVIVAL = 2;
    public static final byte GM_SPECTATE = 3;
    public static final byte DELETE = 4;
    public static final byte RAIN = 5;
    public static final byte SUN = 6;
    public static final byte DAY = 7;
    public static final byte NIGHT = 8;
    public static final byte FREEZE = 9;
    public static final byte KILL = 10;
    public static final byte MAGNET = 11;
    public static final byte DELETE_ALL = 12;
    private int commandOrdinal;
    private String[] cmd;

    public MessageExecuteButton() {
    }

    public MessageExecuteButton(int cmdId, String[] cmd) {
        String[] stringArray;
        this.commandOrdinal = cmdId;
        if (cmd != null) {
            stringArray = cmd;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        }
        this.cmd = stringArray;
    }

    public void fromBytes(ByteBuf buf) {
        this.commandOrdinal = buf.readByte();
        int l = buf.readByte();
        this.cmd = new String[l];
        for (int i = 0; i < l; ++i) {
            this.cmd[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.commandOrdinal);
        buf.writeByte(this.cmd.length);
        for (int i = 0; i < this.cmd.length; ++i) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.cmd[i] != null ? this.cmd[i] : ""));
        }
    }

    public static boolean checkPermissions(EntityPlayer player, MinecraftServer server) {
        if (server.func_71264_H()) {
            return true;
        }
        for (String pl : server.func_184103_al().func_152606_n()) {
            if (!pl.equals(player.getDisplayNameString())) continue;
            return true;
        }
        return false;
    }

    public IMessage onMessage(MessageExecuteButton message, MessageContext ctx) {
        EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
        if (p == null) {
            return null;
        }
        MinecraftServer s = ctx.getServerHandler().field_147369_b.field_71133_b;
        WorldServer world = s.func_71218_a(p.field_71093_bK);
        WorldInfo worldinfo = world.func_72912_H();
        boolean isOP = MessageExecuteButton.checkPermissions((EntityPlayer)p, s);
        boolean error = true;
        switch (message.commandOrdinal) {
            case 1: {
                if (!isOP && ConfigHandler.gamemodeRequiresOP) break;
                error = false;
                p.func_71033_a(GameType.ADVENTURE);
                break;
            }
            case 0: {
                if (!isOP && ConfigHandler.gamemodeRequiresOP) break;
                error = false;
                p.func_71033_a(GameType.CREATIVE);
                break;
            }
            case 2: {
                if (!isOP && ConfigHandler.gamemodeRequiresOP) break;
                error = false;
                p.func_71033_a(GameType.SURVIVAL);
                break;
            }
            case 3: {
                if (!isOP && ConfigHandler.gamemodeRequiresOP) break;
                error = false;
                p.func_71033_a(GameType.SPECTATOR);
                break;
            }
            case 12: {
                if (!isOP && ConfigHandler.deleteRequiresOP) break;
                error = false;
                p.field_71071_by.func_174888_l();
                break;
            }
            case 4: {
                if (!isOP && ConfigHandler.deleteRequiresOP) break;
                error = false;
                p.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                break;
            }
            case 6: {
                if (!isOP && ConfigHandler.weatherRequiresOP) break;
                error = false;
                worldinfo.func_176142_i(1000000);
                worldinfo.func_76080_g(0);
                worldinfo.func_76090_f(0);
                worldinfo.func_76084_b(false);
                worldinfo.func_76069_a(false);
                break;
            }
            case 5: {
                if (!isOP && ConfigHandler.weatherRequiresOP) break;
                error = false;
                worldinfo.func_176142_i(0);
                worldinfo.func_76080_g(1000000);
                worldinfo.func_76090_f(1000000);
                worldinfo.func_76084_b(true);
                worldinfo.func_76069_a(false);
                break;
            }
            case 7: {
                if (!isOP && ConfigHandler.timeRequiresOP) break;
                error = false;
                worldinfo.func_76068_b(1000L);
                break;
            }
            case 8: {
                if (!isOP && ConfigHandler.timeRequiresOP) break;
                error = false;
                world.func_72877_b(13000L);
                break;
            }
            case 9: {
                if (!isOP && ConfigHandler.timeFreezeRequiresOP) break;
                error = false;
                boolean origValue = worldinfo.func_82574_x().func_82766_b("doDaylightCycle");
                worldinfo.func_82574_x().func_82764_b("doDaylightCycle", origValue ? "false" : "true");
                break;
            }
            case 10: {
                if (!isOP && ConfigHandler.killMobsRequiresOP) break;
                error = false;
                for (Entity entity : world.field_72996_f) {
                    if ((entity instanceof EntityPlayer || !(entity instanceof EntityLiving)) && !(entity instanceof EntityItem)) continue;
                    world.func_72900_e(entity);
                }
                break;
            }
        }
        if (error) {
            TextComponentTranslation msg = new TextComponentTranslation("commands.generic.permission", new Object[0]);
            msg.func_150255_a(msg.func_150256_b().func_150238_a(TextFormatting.RED));
            p.func_145747_a((ITextComponent)msg);
        }
        return null;
    }
}

