/*
 * Decompiled with CFR 0.152.
 */
package de.universallp.justenoughbuttons.client;

import de.universallp.justenoughbuttons.client.ClientProxy;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;

public class MobOverlayRenderer {
    private static Map<BlockPos, SpawnType> cache = new HashMap<BlockPos, SpawnType>();

    public static void renderMobSpawnOverlay() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        GlStateManager.func_179137_b((double)(-ClientProxy.renderManager.field_78730_l), (double)(-ClientProxy.renderManager.field_78731_m), (double)(-ClientProxy.renderManager.field_78728_n));
        GL11.glLineWidth((float)1.5f);
        GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)0.0f);
        for (BlockPos p : cache.keySet()) {
            SpawnType t = cache.get(p);
            if (t == SpawnType.ALWAYS) {
                MobOverlayRenderer.renderCross(p, 1.0f, 0.0f, 0.0f);
                continue;
            }
            MobOverlayRenderer.renderCross(p, 1.0f, 1.0f, 0.0f);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    private static void renderCross(BlockPos pos, float r, float g, float b) {
        double y = (double)pos.func_177956_o() + 0.005;
        double x0 = pos.func_177958_n();
        double x1 = x0 + 1.0;
        double z0 = pos.func_177952_p();
        double z1 = z0 + 1.0;
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer renderer = tess.func_178180_c();
        renderer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b(x0, y, z0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x1, y, z1).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x1, y, z0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x0, y, z1).func_181666_a(r, g, b, 1.0f).func_181675_d();
        tess.func_78381_a();
    }

    public static void cacheMobSpawns(Entity entity) {
        cache.clear();
        World world = entity.field_70170_p;
        int entX = (int)entity.field_70165_t;
        int entY = MathHelper.func_76125_a((int)((int)entity.field_70163_u), (int)16, (int)(world.func_72800_K() - 16));
        int entZ = (int)entity.field_70161_v;
        for (int x = entX - 16; x <= entX + 16; ++x) {
            for (int z = entZ - 16; z <= entZ + 16; ++z) {
                BlockPos pos = new BlockPos(x, entY, z);
                Chunk chunk = world.func_175726_f(pos);
                Biome biome = world.func_180494_b(pos);
                if (biome.func_76747_a(EnumCreatureType.MONSTER).isEmpty() || biome.func_76741_f() <= 0.0f) continue;
                for (int y = entY - 16; y < entY + 16; ++y) {
                    SpawnType spawnType;
                    if (!world.func_175623_d(new BlockPos(x, y, z)) || (spawnType = MobOverlayRenderer.getSpawnType(chunk, x, y, z)) == SpawnType.NEVER) continue;
                    cache.put(new BlockPos(x, y, z), spawnType);
                }
            }
        }
    }

    private static SpawnType getSpawnType(Chunk chunk, int x, int y, int z) {
        BlockPos pos;
        World world = chunk.func_177412_p();
        if (!WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND, (World)world, (BlockPos)(pos = new BlockPos(x, y, z))) || chunk.func_177413_a(EnumSkyBlock.BLOCK, pos) >= 8) {
            return SpawnType.NEVER;
        }
        BlockPos p = new BlockPos(x, y, z);
        AxisAlignedBB aabb = new AxisAlignedBB(p);
        if (!world.func_72855_b(aabb) || !world.func_72839_b(null, aabb).isEmpty() || world.func_72953_d(aabb)) {
            return SpawnType.NEVER;
        }
        if (chunk.func_177413_a(EnumSkyBlock.SKY, pos) >= 8) {
            return SpawnType.NIGHT_ONLY;
        }
        return SpawnType.ALWAYS;
    }

    public static void clearCache() {
        cache.clear();
    }

    private static enum SpawnType {
        NEVER,
        NIGHT_ONLY,
        ALWAYS;

    }
}

