/*
 * Decompiled with CFR 0.152.
 */
package de.universallp.justenoughbuttons.core.network;

import de.universallp.justenoughbuttons.JEIButtons;
import de.universallp.justenoughbuttons.core.handlers.ConfigHandler;
import de.universallp.justenoughbuttons.core.network.MessageExecuteButton;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageRequestStacks
implements IMessage,
IMessageHandler<MessageRequestStacks, IMessage> {
    private static final int MAX_REQUEST_SIZE = Short.MAX_VALUE;
    private NBTTagCompound[] mainInventory;
    private NBTTagCompound[] armorInventory;
    private NBTTagCompound offHand;

    public MessageRequestStacks() {
    }

    public MessageRequestStacks(NBTTagCompound[] main, NBTTagCompound[] armor, NBTTagCompound off) {
        this.mainInventory = main;
        this.armorInventory = armor;
        this.offHand = off;
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        if (buf.readBoolean()) {
            this.mainInventory = new NBTTagCompound[buf.readByte()];
            for (i = 0; i < this.mainInventory.length; ++i) {
                this.mainInventory[i] = ByteBufUtils.readTag((ByteBuf)buf);
            }
        }
        if (buf.readBoolean()) {
            this.armorInventory = new NBTTagCompound[buf.readByte()];
            for (i = 0; i < this.armorInventory.length; ++i) {
                this.armorInventory[i] = ByteBufUtils.readTag((ByteBuf)buf);
            }
        }
        if (buf.readBoolean()) {
            this.offHand = ByteBufUtils.readTag((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag;
        int i;
        boolean flag = this.mainInventory != null && this.mainInventory.length > 0;
        buf.writeBoolean(flag);
        if (flag) {
            buf.writeByte(this.mainInventory.length);
            for (i = 0; i < this.mainInventory.length; ++i) {
                tag = this.mainInventory[i];
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                if (tag.toString().getBytes().length < Short.MAX_VALUE) {
                    ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
                    continue;
                }
                JEIButtons.logInfo("That NBT tag was just too long.", new Object[0]);
                ByteBufUtils.writeTag((ByteBuf)buf, null);
            }
        }
        flag = this.armorInventory != null && this.armorInventory.length > 0;
        buf.writeBoolean(flag);
        if (flag) {
            buf.writeByte(this.armorInventory.length);
            for (i = 0; i < this.armorInventory.length; ++i) {
                tag = this.armorInventory[i];
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
            }
        }
        flag = this.offHand != null;
        buf.writeBoolean(flag);
        if (flag) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.offHand);
        }
    }

    public IMessage onMessage(MessageRequestStacks message, MessageContext ctx) {
        EntityPlayerMP p = ctx.getServerHandler().field_147369_b;
        if (p != null) {
            int i;
            boolean isOP = MessageExecuteButton.checkPermissions((EntityPlayer)p, p.field_71133_b);
            if (ConfigHandler.saveRequireOP && !isOP) {
                TextComponentTranslation msg = new TextComponentTranslation("commands.generic.permission", new Object[0]);
                msg.func_150255_a(msg.func_150256_b().func_150238_a(TextFormatting.RED));
                p.func_146105_b((ITextComponent)msg);
                return null;
            }
            p.field_71071_by.func_174888_l();
            if (message.mainInventory != null) {
                for (i = 0; i < message.mainInventory.length; ++i) {
                    if (message.mainInventory[i] == null) continue;
                    p.field_71071_by.field_70462_a[i] = ItemStack.func_77949_a((NBTTagCompound)message.mainInventory[i]);
                }
            }
            if (message.armorInventory != null) {
                for (i = 0; i < message.armorInventory.length; ++i) {
                    if (message.armorInventory[i] == null) continue;
                    p.field_71071_by.field_70460_b[i] = ItemStack.func_77949_a((NBTTagCompound)message.armorInventory[i]);
                }
            }
            if (message.offHand != null) {
                p.field_71071_by.field_184439_c[0] = ItemStack.func_77949_a((NBTTagCompound)message.offHand);
            }
        }
        p.field_71071_by.func_70296_d();
        p.field_71069_bz.func_75142_b();
        return null;
    }
}

