/*
 * Decompiled with CFR 0.152.
 */
package de.universallp.justenoughbuttons.client.handlers;

import de.universallp.justenoughbuttons.JEIButtons;
import de.universallp.justenoughbuttons.client.ClientProxy;
import de.universallp.justenoughbuttons.client.handlers.EventHandlers;
import de.universallp.justenoughbuttons.core.CommonProxy;
import de.universallp.justenoughbuttons.core.handlers.ConfigHandler;
import de.universallp.justenoughbuttons.core.network.MessageRequestStacks;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class InventorySaveHandler {
    private static GuiButton[] saveButtons = new GuiButton[4];
    static InventorySnapshot[] saves = new InventorySnapshot[4];
    private static final String replaceCommand = "replaceitem entity @p %s %s %s %s %s";

    public static void init() {
        String load = I18n.func_135052_a((String)"justenoughbuttons.load", (Object[])new Object[0]) + " ";
        String save = I18n.func_135052_a((String)"justenoughbuttons.save", (Object[])new Object[0]) + " ";
        for (int i = 0; i < saveButtons.length; ++i) {
            InventorySaveHandler.saveButtons[i] = new GuiButton(i, ConfigHandler.xOffset, 110 + ConfigHandler.yOffset + 22 * i, 50, 20, (saves[i] == null ? save : load) + (i + 1));
        }
    }

    static void click(int mouseX, int mouseY, boolean rightMouse) {
        if (!rightMouse) {
            for (int i = 0; i < saveButtons.length; ++i) {
                if (!saveButtons[i].func_146116_c(ClientProxy.mc, mouseX, mouseY)) continue;
                JEIButtons.proxy.playClick();
                if (saves[i] == null) {
                    InventorySaveHandler.saves[i] = new InventorySnapshot(ClientProxy.player.field_71071_by);
                    String load = I18n.func_135052_a((String)"justenoughbuttons.load", (Object[])new Object[0]) + " ";
                    InventorySaveHandler.saveButtons[i].field_146126_j = load + (i + 1);
                } else if (ClientProxy.player.field_71071_by.func_70445_o() != null) {
                    InventorySaveHandler.saves[i].icon = ClientProxy.player.field_71071_by.func_70445_o().func_77946_l();
                } else {
                    saves[i].giveToPlayer();
                }
                break;
            }
        } else {
            for (int i = 0; i < saveButtons.length; ++i) {
                if (!saveButtons[i].func_146116_c(ClientProxy.mc, mouseX, mouseY)) continue;
                JEIButtons.proxy.playClick();
                InventorySaveHandler.saves[i] = null;
                String save = I18n.func_135052_a((String)"justenoughbuttons.save", (Object[])new Object[0]) + " ";
                InventorySaveHandler.saveButtons[i].field_146126_j = save + (i + 1);
                break;
            }
        }
    }

    static void drawButtons(int mouseX, int mouseY) {
        boolean anyButtonHovered = false;
        if (saves == null || saves.length <= 0) {
            return;
        }
        for (GuiButton s : saveButtons) {
            s.func_146112_a(ClientProxy.mc, mouseX, mouseY);
            if (s.func_146115_a()) {
                EventHandlers.skipSaveClickCount = 2;
                anyButtonHovered = true;
            }
            if (saves[s.field_146127_k] == null || InventorySaveHandler.saves[s.field_146127_k].icon == null) continue;
            RenderHelper.func_74519_b();
            RenderHelper.func_74520_c();
            ClientProxy.mc.func_175599_af().func_180450_b(InventorySaveHandler.saves[s.field_146127_k].icon, s.field_146128_h + s.field_146120_f + 2, s.field_146129_i + 2);
            RenderHelper.func_74518_a();
        }
        if (!anyButtonHovered) {
            EventHandlers.skipSaveClickCount = 0;
        }
    }

    static class InventorySnapshot {
        ItemStack icon;
        NBTTagCompound[] mainInventory;
        NBTTagCompound[] armorInventory;
        NBTTagCompound offHandInventory;

        InventorySnapshot(NBTTagCompound icon, NBTTagCompound[] mainInventory, NBTTagCompound[] armorInventory, NBTTagCompound offHandInventory) {
            this.icon = ItemStack.func_77949_a((NBTTagCompound)icon);
            this.mainInventory = mainInventory;
            this.armorInventory = armorInventory;
            this.offHandInventory = offHandInventory;
        }

        InventorySnapshot(InventoryPlayer inv) {
            NBTTagCompound nbt;
            int i;
            this.mainInventory = new NBTTagCompound[inv.field_70462_a.length];
            this.armorInventory = new NBTTagCompound[inv.field_70460_b.length];
            this.offHandInventory = new NBTTagCompound();
            for (i = 0; i < inv.field_70462_a.length; ++i) {
                if (inv.field_70462_a[i] == null) continue;
                nbt = new NBTTagCompound();
                inv.field_70462_a[i].func_77955_b(nbt);
                this.mainInventory[i] = nbt;
            }
            for (i = 0; i < inv.field_70460_b.length; ++i) {
                if (inv.field_70460_b[i] == null) continue;
                nbt = new NBTTagCompound();
                inv.field_70460_b[i].func_77955_b(nbt);
                this.armorInventory[i] = nbt;
            }
            if (inv.field_184439_c[0] != null) {
                NBTTagCompound nbt2 = new NBTTagCompound();
                inv.field_184439_c[0].func_77955_b(nbt2);
                this.offHandInventory = nbt2;
            }
        }

        void giveToPlayer() {
            if (!JEIButtons.isServerSidePresent) {
                ItemStack s;
                String cmd;
                String nbt;
                ItemStack s2;
                int i;
                JEIButtons.sendCommand("clear");
                for (i = 0; i < this.mainInventory.length; ++i) {
                    if (this.mainInventory[i] == null || (s2 = ItemStack.func_77949_a((NBTTagCompound)this.mainInventory[i])) == null) continue;
                    nbt = s2.func_77978_p() != null ? s2.func_77978_p().toString() : "";
                    cmd = i < 9 ? String.format(InventorySaveHandler.replaceCommand, "slot.hotbar." + i, s2.func_77973_b().getRegistryName(), s2.field_77994_a, s2.func_77952_i(), nbt) : String.format(InventorySaveHandler.replaceCommand, "slot.inventory." + (i - 9), s2.func_77973_b().getRegistryName(), s2.field_77994_a, s2.func_77952_i(), nbt);
                    if (!this.checkCommandLength(cmd)) continue;
                    JEIButtons.sendCommand(cmd);
                }
                for (i = 0; i < this.armorInventory.length; ++i) {
                    if (this.armorInventory[i] == null || (s2 = ItemStack.func_77949_a((NBTTagCompound)this.armorInventory[i])) == null) continue;
                    nbt = s2.func_77978_p() != null ? s2.func_77978_p().toString() : "";
                    cmd = String.format(InventorySaveHandler.replaceCommand, "slot.armor." + this.idToSlot(i), s2.func_77973_b().getRegistryName(), s2.field_77994_a, s2.func_77952_i(), nbt);
                    if (!this.checkCommandLength(cmd)) continue;
                    JEIButtons.sendCommand(cmd);
                }
                if (this.offHandInventory != null && (s = ItemStack.func_77949_a((NBTTagCompound)this.offHandInventory)) != null) {
                    nbt = s.func_77978_p() != null ? s.func_77978_p().toString() : "";
                    cmd = String.format(InventorySaveHandler.replaceCommand, "slot.weapon.offhand", s.func_77973_b().getRegistryName(), s.field_77994_a, s.func_77952_i(), nbt);
                    if (this.checkCommandLength(cmd)) {
                        JEIButtons.sendCommand(cmd);
                    }
                }
            } else {
                CommonProxy.INSTANCE.sendToServer((IMessage)new MessageRequestStacks(this.mainInventory, this.armorInventory, this.offHandInventory));
            }
            ClientProxy.player.field_71071_by.func_70296_d();
        }

        boolean checkCommandLength(String cmd) {
            if (cmd.length() > 100) {
                ClientProxy.player.func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"justenoughbuttons.nbttoolong", (Object[])new Object[0])));
                return false;
            }
            return true;
        }

        String idToSlot(int i) {
            switch (i) {
                case 0: {
                    return "feet";
                }
                case 1: {
                    return "legs";
                }
                case 2: {
                    return "chest";
                }
                case 3: {
                    return "head";
                }
            }
            return "head";
        }
    }
}

