/*
 * Decompiled with CFR 0.152.
 */
package de.universallp.justenoughbuttons.client.handlers;

import de.universallp.justenoughbuttons.JEIButtons;
import de.universallp.justenoughbuttons.client.ClientProxy;
import de.universallp.justenoughbuttons.client.EnumButtonCommands;
import de.universallp.justenoughbuttons.client.Localization;
import de.universallp.justenoughbuttons.client.MobOverlayRenderer;
import de.universallp.justenoughbuttons.client.handlers.CommandHelper;
import de.universallp.justenoughbuttons.client.handlers.InventorySaveHandler;
import de.universallp.justenoughbuttons.client.handlers.ModSubsetButtonHandler;
import de.universallp.justenoughbuttons.client.handlers.SaveFileHandler;
import de.universallp.justenoughbuttons.core.CommonProxy;
import de.universallp.justenoughbuttons.core.handlers.ConfigHandler;
import de.universallp.justenoughbuttons.core.network.MessageNotifyClient;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class EventHandlers {
    private boolean isLMBDown = false;
    private boolean isRMBDown = false;
    private static BlockPos lastPlayerPos = null;
    private boolean drawMobOverlay = false;
    static int skipSaveClickCount = 0;
    static int skipModClickCount = 0;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent e) {
        if (ConfigHandler.showButtons && e.getGui() != null && e.getGui() instanceof GuiContainer) {
            List<String> tip;
            int mouseY = JEIButtons.proxy.getMouseY();
            int mouseX = JEIButtons.proxy.getMouseX();
            if (JEIButtons.isAnyButtonHovered && (tip = Localization.getTooltip(JEIButtons.hoveredButton)) != null) {
                GuiUtils.drawHoveringText(tip, (int)mouseX, (int)(mouseY < 17 ? 17 : mouseY), (int)ClientProxy.mc.field_71443_c, (int)ClientProxy.mc.field_71440_d, (int)-1, (FontRenderer)ClientProxy.mc.field_71466_p);
                RenderHelper.func_74518_a();
            }
            if (ConfigHandler.enableSubsets) {
                ModSubsetButtonHandler.drawSubsetList(mouseX, mouseY);
            }
        }
        if (e.getGui() instanceof GuiConfig) {
            GuiConfigEntries eL = ((GuiConfig)e.getGui()).entryList;
            GuiConfig cfg = (GuiConfig)e.getGui();
            if (cfg.titleLine2 != null && cfg.titleLine2.equals("position")) {
                int y = EventHandlers.getInt(1, eL);
                int x = EventHandlers.getInt(0, eL);
                GuiUtils.drawGradientRect((int)10, (int)x, (int)y, (int)(x + 75), (int)(y + 75), (int)0x77888888, (int)0x77888888);
                ClientProxy.mc.field_71466_p.func_78276_b("[Buttons]", x + 14, y + 10, 0xFFFFFF);
            }
        }
    }

    private static int getInt(int i, GuiConfigEntries eL) {
        if (i < eL.func_148127_b() && eL.getListEntry(i) != null && String.valueOf(eL.getListEntry(i).getCurrentValue()).length() > 0 && String.valueOf(eL.getListEntry(i).getCurrentValue()).length() < 5 && !String.valueOf(eL.getListEntry(i).getCurrentValue()).equals("-")) {
            return Integer.valueOf(String.valueOf(eL.getListEntry(i).getCurrentValue()));
        }
        return -1;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawBackgroundEventPost(GuiScreenEvent.BackgroundDrawnEvent e) {
        if (JEIButtons.configHasChanged) {
            JEIButtons.configHasChanged = false;
            JEIButtons.setUpPositions();
        }
        if (JEIButtons.isServerSidePresent && e.getGui() instanceof GuiMainMenu) {
            JEIButtons.isServerSidePresent = false;
            JEIButtons.isSpongePresent = false;
        } else if (ConfigHandler.showButtons && e.getGui() != null && e.getGui() instanceof GuiContainer) {
            int mouseY = JEIButtons.proxy.getMouseY();
            int mouseX = JEIButtons.proxy.getMouseX();
            if (JEIButtons.btnGameMode == EnumButtonCommands.SPECTATE && !ConfigHandler.enableSpectatoreMode || JEIButtons.btnGameMode == EnumButtonCommands.ADVENTURE && !ConfigHandler.enableAdventureMode) {
                JEIButtons.btnGameMode = JEIButtons.btnGameMode.cycle();
            }
            JEIButtons.isAnyButtonHovered = false;
            JEIButtons.btnGameMode.draw();
            JEIButtons.btnTrash.draw();
            JEIButtons.btnSun.draw();
            JEIButtons.btnRain.draw();
            JEIButtons.btnDay.draw();
            JEIButtons.btnNight.draw();
            JEIButtons.btnNoMobs.draw();
            JEIButtons.btnFreeze.draw();
            JEIButtons.btnMagnet.draw();
            if (ConfigHandler.enableSaves) {
                InventorySaveHandler.drawButtons(mouseX, mouseY);
            }
            if (ModSubsetButtonHandler.ENABLE_SUBSETS && ConfigHandler.enableSubsets) {
                ModSubsetButtonHandler.drawButtons(mouseX, mouseY, ClientProxy.getGuiTop((GuiContainer)e.getGui()));
            }
            for (EnumButtonCommands btn : JEIButtons.btnCustom) {
                btn.draw();
            }
            this.adjustGamemode();
            if (Mouse.isButtonDown((int)0) && !this.isLMBDown) {
                this.isLMBDown = true;
                if (JEIButtons.isAnyButtonHovered && JEIButtons.hoveredButton.isEnabled) {
                    CommandHelper.handleClick(JEIButtons.hoveredButton);
                    JEIButtons.proxy.playClick();
                } else {
                    if (ConfigHandler.enableSaves) {
                        InventorySaveHandler.click(mouseX, mouseY, false);
                    }
                    ModSubsetButtonHandler.click(mouseX, mouseY);
                }
            } else if (!Mouse.isButtonDown((int)0)) {
                this.isLMBDown = false;
            }
            if (Mouse.isButtonDown((int)1) && !this.isRMBDown) {
                this.isRMBDown = true;
                InventorySaveHandler.click(mouseX, mouseY, true);
            } else if (!Mouse.isButtonDown((int)1)) {
                this.isRMBDown = false;
            }
        }
    }

    private void adjustGamemode() {
        GameType t = ClientProxy.mc.field_71442_b.func_178889_l();
        boolean doSwitch = false;
        if (t == GameType.CREATIVE && JEIButtons.btnGameMode == EnumButtonCommands.CREATIVE) {
            doSwitch = true;
        } else if (t == GameType.SURVIVAL && JEIButtons.btnGameMode == EnumButtonCommands.SURVIVAL) {
            doSwitch = true;
        } else if (t == GameType.ADVENTURE && JEIButtons.btnGameMode == EnumButtonCommands.ADVENTURE) {
            doSwitch = true;
        } else if (t == GameType.SPECTATOR && JEIButtons.btnGameMode == EnumButtonCommands.SPECTATE) {
            doSwitch = true;
        }
        if (doSwitch) {
            JEIButtons.btnGameMode = JEIButtons.btnGameMode.cycle();
        }
    }

    @SubscribeEvent
    public void onWorldJoin(EntityJoinWorldEvent e) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            InventorySaveHandler.init();
            if (e.getEntity() instanceof EntityPlayer) {
                ClientProxy.player = FMLClientHandler.instance().getClientPlayerEntity();
                JEIButtons.btnGameMode = ((EntityPlayer)e.getEntity()).field_71075_bZ.field_75098_d ? JEIButtons.btnGameMode.cycle() : EnumButtonCommands.CREATIVE;
            }
        } else if (e.getEntity() != null && e.getEntity() instanceof EntityPlayerMP) {
            CommonProxy.INSTANCE.sendTo((IMessage)new MessageNotifyClient(), (EntityPlayerMP)e.getEntity());
        }
    }

    @SubscribeEvent
    public void onWorldLeave(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (SaveFileHandler.SAVE_SNAPSHOTS) {
            try {
                ClientProxy.saveHandler.saveForPlayer();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        JEIButtons.isServerSidePresent = false;
    }

    @SubscribeEvent
    public void handleKeyInputEvent(GuiScreenEvent.KeyboardInputEvent.Post e) {
        GuiScreen gui = ClientProxy.mc.field_71462_r;
        if (gui != null && gui instanceof GuiContainer) {
            int keyCode = Keyboard.getEventKey();
            if (1 == keyCode) {
                skipModClickCount = 0;
                skipSaveClickCount = 0;
            }
            if (ClientProxy.makeCopyKey.isActiveAndMatches(keyCode)) {
                Slot hovered = ((GuiContainer)gui).getSlotUnderMouse();
                if (hovered != null && ClientProxy.player.field_71071_by.func_70445_o() == null && hovered.func_75211_c() != null && hovered.func_75216_d()) {
                    ItemStack stack = hovered.func_75211_c().func_77946_l();
                    stack.field_77994_a = 1;
                    NBTTagCompound t = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
                    t.func_74757_a("JEI_Ghost", true);
                    stack.func_77982_d(t);
                    ClientProxy.player.field_71071_by.func_70437_b(stack);
                }
            } else if (ClientProxy.hideAll.isActiveAndMatches(keyCode) && Keyboard.getEventKeyState()) {
                ConfigHandler.showButtons = !ConfigHandler.showButtons;
            }
        }
    }

    @SubscribeEvent
    public void onMouseEvent(GuiScreenEvent.MouseInputEvent event) {
        if (Mouse.getEventButton() == 0) {
            if (JEIButtons.isAnyButtonHovered && JEIButtons.hoveredButton == EnumButtonCommands.DELETE && ClientProxy.player.field_71071_by.func_70445_o() != null) {
                event.setResult(Event.Result.DENY);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            }
            if (skipSaveClickCount > 0) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                event.setResult(Event.Result.DENY);
                --skipSaveClickCount;
            }
            if (skipModClickCount > 0) {
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                event.setResult(Event.Result.DENY);
                --skipModClickCount;
            }
        }
        if (Mouse.getDWheel() != 0 && ModSubsetButtonHandler.isListShown) {
            ModSubsetButtonHandler.scroll(Mouse.getEventDWheel());
        }
    }

    @SubscribeEvent
    public void onKeyPressed(InputEvent.KeyInputEvent event) {
        if (JEIButtons.enableOverlays) {
            int kC = Keyboard.getEventKey();
            if (Keyboard.getEventKeyState()) {
                if (ClientProxy.mobOverlay.isActiveAndMatches(kC)) {
                    boolean bl = this.drawMobOverlay = !this.drawMobOverlay;
                    if (!this.drawMobOverlay) {
                        MobOverlayRenderer.clearCache();
                        lastPlayerPos = null;
                    }
                }
                if (ClientProxy.chunkOverlay.isActiveAndMatches(kC)) {
                    ClientProxy.mc.field_184132_p.func_190075_b();
                }
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!(FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT || lastPlayerPos != null && lastPlayerPos.equals((Object)ClientProxy.player.func_180425_c()))) {
            if (this.drawMobOverlay) {
                MobOverlayRenderer.cacheMobSpawns((Entity)ClientProxy.player);
            }
            if (this.drawMobOverlay) {
                lastPlayerPos = ClientProxy.player.func_180425_c();
            }
        }
    }

    @SubscribeEvent
    public void onWorldDraw(RenderWorldLastEvent event) {
        if (this.drawMobOverlay) {
            MobOverlayRenderer.renderMobSpawnOverlay();
        }
        if (ClientProxy.mc.field_71462_r == null) {
            skipSaveClickCount = 0;
            ModSubsetButtonHandler.isListShown = false;
        }
    }

    @SubscribeEvent
    public void onJoinServer(FMLNetworkEvent.ClientConnectedToServerEvent e) {
        for (String ip : ConfigHandler.spongeServers) {
            if (!Minecraft.func_71410_x().func_147104_D().field_78845_b.contains(ip)) continue;
            JEIButtons.isSpongePresent = true;
            JEIButtons.logInfo("Sponge support is enabled for this server!", new Object[0]);
            break;
        }
    }
}

